/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ctx;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.ctx.CtxMetadata;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.log.Log;

public class Ctx
extends RapidoidThing
implements CtxMetadata {
    private static final AtomicLong ID_COUNTER = new AtomicLong();
    private final long id = ID_COUNTER.incrementAndGet();
    private final String tag;
    private volatile int referenceCounter = 1;
    private volatile UserInfo user;
    private volatile Object exchange;
    private volatile boolean closed = false;
    private volatile ThreadLocal<Object> persisters = new ThreadLocal();
    private final List<Object> persistersToClose = Collections.synchronizedList(new LinkedList());
    private final Map<Object, Object> extras = Coll.synchronizedMap();

    Ctx(String tag) {
        this.tag = tag;
    }

    public UserInfo user() {
        this.ensureNotClosed();
        return this.user;
    }

    public void setUser(UserInfo user) {
        this.ensureNotClosed();
        this.user = user;
    }

    public <T> T exchange() {
        this.ensureNotClosed();
        return (T)this.exchange;
    }

    public void setExchange(Object exchange) {
        this.ensureNotClosed();
        this.exchange = exchange;
    }

    public synchronized <P> P persister() {
        this.ensureNotClosed();
        Object persister = this.persisters.get();
        if (persister == null) {
            persister = Ctxs.createPersister(this);
            this.persisters.set(persister);
            this.persistersToClose.add(persister);
        }
        return (P)persister;
    }

    public synchronized void setPersister(Object persister) {
        this.persisters.set(persister);
    }

    public synchronized Ctx span() {
        this.ensureNotClosed();
        ++this.referenceCounter;
        Log.debug("Spanning context", "ctx", this);
        return this;
    }

    synchronized void close() {
        this.ensureNotClosed();
        Log.debug("Closing context", "ctx", this);
        --this.referenceCounter;
        if (this.referenceCounter == 0) {
            this.clear();
        } else if (this.referenceCounter < 0) {
            throw new IllegalStateException("Reference counter < 0 for context: " + this);
        }
    }

    private synchronized void clear() {
        this.ensureNotClosed();
        Log.debug("Clearing context", "ctx", this);
        this.referenceCounter = 0;
        this.user = null;
        this.exchange = null;
        this.persisters = null;
        for (Object persister : this.persistersToClose) {
            Ctxs.closePersister(this, persister);
        }
        this.persistersToClose.clear();
        this.extras.clear();
        this.closed = true;
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new RuntimeException("The context is closed!");
        }
    }

    public String toString() {
        int maxLen = 10;
        return this.prefixed("Ctx [id=" + this.id + ", tag=" + this.tag + ", user=" + this.user + ", exchange=" + this.exchange + ", referenceCounter=" + this.referenceCounter + ", closed=" + this.closed + ", persistersToClose=" + this.toString(this.persistersToClose, 10) + ", extras=" + this.toString(this.extras.entrySet(), 10) + "]");
    }

    private String prefixed(String asStr) {
        String isClosed = this.closed ? " <CLOSED>" : "";
        String prefix = "Ctx#" + this.id + ":" + this.tag + isClosed;
        return prefix + " " + asStr;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Map<Object, Object> extras() {
        this.ensureNotClosed();
        return this.extras;
    }

    public String tag() {
        return this.tag;
    }
}

