/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.config.Conf;
import org.rapidoid.crypto.AESCypherTool;
import org.rapidoid.crypto.CryptoKey;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Crypto
extends RapidoidThing {
    public static final SecureRandom RANDOM = new SecureRandom();
    private static final AESCypherTool AES = new AESCypherTool();
    private static final String HMAC_SHA_256 = "HmacSHA256";
    static final int HMAC_KEY_LENGTH = 256;
    private static volatile CryptoKey secretKey;
    static final byte[] DEFAULT_PBKDF2_SALT;

    public static void reset() {
        secretKey = null;
    }

    public static MessageDigest digest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte("Cannot find crypto algorithm: " + algorithm);
        }
    }

    public static Cipher cipher(String transformation) {
        try {
            return Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte("Cannot find crypto algorithm: " + transformation);
        }
        catch (NoSuchPaddingException e) {
            throw U.rte("No such padding: " + transformation);
        }
    }

    public static String bytesAsText(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static byte[] md5Bytes(byte[] bytes) {
        MessageDigest md5 = Crypto.digest("MD5");
        md5.update(bytes);
        return md5.digest();
    }

    public static String md5(byte[] bytes) {
        return Crypto.bytesAsText(Crypto.md5Bytes(bytes));
    }

    public static String md5(String data) {
        return Crypto.md5(data.getBytes());
    }

    public static byte[] sha1Bytes(byte[] bytes) {
        MessageDigest sha1 = Crypto.digest("SHA-1");
        sha1.update(bytes);
        return sha1.digest();
    }

    public static String sha1(byte[] bytes) {
        return Crypto.bytesAsText(Crypto.sha1Bytes(bytes));
    }

    public static String sha1(String data) {
        return Crypto.sha1(data.getBytes());
    }

    public static byte[] sha512Bytes(byte[] bytes) {
        MessageDigest sha1 = Crypto.digest("SHA-512");
        sha1.update(bytes);
        return sha1.digest();
    }

    public static String sha512(byte[] bytes) {
        return Crypto.bytesAsText(Crypto.sha512Bytes(bytes));
    }

    public static String sha512(String data) {
        return Crypto.sha512(data.getBytes());
    }

    public static synchronized CryptoKey getSecretKey() {
        if (secretKey == null) {
            Crypto.initSecret();
        }
        U.notNull(secretKey, "secret key", new Object[0]);
        return secretKey;
    }

    private static synchronized void initSecret() {
        char[] src;
        String secret = Conf.ROOT.entry("secret").str().getOrNull();
        if (secret == null) {
            Log.warn("!Application secret was not specified, generating random secret!");
            src = Str.toHex(Crypto.randomBytes(128)).toCharArray();
        } else {
            src = secret.toCharArray();
        }
        secretKey = CryptoKey.from(src);
    }

    public static String randomStr(int byteCount) {
        return DatatypeConverter.printHexBinary((byte[])Crypto.randomBytes(byteCount));
    }

    public static byte[] encrypt(byte[] data, CryptoKey key) {
        try {
            return AES.encrypt(data, key);
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public static byte[] decrypt(byte[] data, CryptoKey key) {
        try {
            return AES.decrypt(data, key);
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public static byte[] encrypt(byte[] data) {
        return Crypto.encrypt(data, Crypto.getSecretKey());
    }

    public static byte[] decrypt(byte[] data) {
        return Crypto.decrypt(data, Crypto.getSecretKey());
    }

    public static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int length) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterations, length);
            return Crypto.getPBKDFInstance().generateSecret(keySpec).getEncoded();
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public static String passwordHash(char[] password) {
        return Crypto.passwordHash(password, 100000);
    }

    public static String passwordHash(char[] password, int iterations) {
        return Crypto.passwordHash(password, iterations, Crypto.randomBytes(20));
    }

    public static String passwordHash(char[] password, int iterations, byte[] salt) {
        byte[] hash = Crypto.pbkdf2(password, salt, iterations, 256);
        return Str.toBase64(hash) + "$" + Str.toBase64(salt) + "$" + iterations;
    }

    public static boolean passwordMatches(char[] password, String saltedHash) {
        int iterations;
        String[] parts = saltedHash.split("\\$");
        if (parts.length != 3) {
            return false;
        }
        byte[] expectedHash = Str.fromBase64(parts[0]);
        byte[] salt = Str.fromBase64(parts[1]);
        try {
            iterations = U.num(parts[2]);
        }
        catch (Exception e) {
            return false;
        }
        byte[] realHash = Crypto.pbkdf2(password, salt, iterations, 256);
        return Arrays.equals(expectedHash, realHash);
    }

    public static boolean passwordMatches(String password, String saltedHash) {
        return Crypto.passwordMatches(password.toCharArray(), saltedHash);
    }

    public static byte[] randomBytes(int byteCount) {
        byte[] bytes = new byte[byteCount];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static byte[] hmac(byte[] data, byte[] secret, byte[] salt) throws Exception {
        Mac m = Mac.getInstance(HMAC_SHA_256);
        m.init(new SecretKeySpec(secret, HMAC_SHA_256));
        return m.doFinal(data);
    }

    public static boolean hmacMatches(byte[] hmac, byte[] data, byte[] secret, byte[] salt) throws Exception {
        return MessageDigest.isEqual(hmac, Crypto.hmac(data, secret, salt));
    }

    private static SecretKeyFactory getPBKDFInstance() throws NoSuchAlgorithmException {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
    }

    static {
        DEFAULT_PBKDF2_SALT = new byte[]{0, -3, -76, 48, 23, 1, 43, -41, -120, 45, -92, -113, -100, 70, -68, -46, 96, -93, 15, 99};
    }
}

