/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.crypto;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Arr;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.crypto.CryptoKey;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class AESCypherTool
extends RapidoidThing {
    private static final String AES_MODE = "AES/CBC/PKCS5Padding";
    static final int AES_KEY_LENGTH = AESCypherTool.calcAESKeyLength();

    private static int calcAESKeyLength() {
        int maxKeyLen;
        try {
            maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte(e);
        }
        return maxKeyLen > 256 ? 256 : 128;
    }

    public byte[] encrypt(byte[] input, CryptoKey key) throws Exception {
        byte[] aesIV = Crypto.randomBytes(16);
        byte[] encrypted = this.aes(input, key.encryptionKey, aesIV, 1);
        byte[] hmacSalt = Crypto.randomBytes(20);
        byte[] hmac = Crypto.hmac(Arr.merge(encrypted, aesIV), key.hmacKey, hmacSalt);
        return Arr.merge(aesIV, encrypted, hmacSalt, hmac);
    }

    public byte[] decrypt(byte[] input, CryptoKey key) throws Exception {
        U.must(input.length >= 68, "Not enough data to decrypt!");
        byte[] aesIV = new byte[16];
        byte[] encrypted = new byte[input.length - 16 - 20 - 32];
        byte[] hmacSalt = new byte[20];
        byte[] hmac = new byte[32];
        Arr.split(input, aesIV, encrypted, hmacSalt, hmac);
        if (Crypto.hmacMatches(hmac, Arr.merge(encrypted, aesIV), key.hmacKey, hmacSalt)) {
            return this.aes(encrypted, key.encryptionKey, aesIV, 2);
        }
        Log.debug("Cannot decrypt invalid data. Has the secret changed?");
        return null;
    }

    private byte[] aes(byte[] data, byte[] key, byte[] iv, int mode) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        cipher.init(mode, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }
}

