/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigUtil;
import org.rapidoid.env.Env;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ConfigLoaderUtil
extends RapidoidThing {
    public static void loadConfig(Config config, List<String> loaded) {
        String nameBase = config.getFilenameBase();
        if (U.notEmpty(nameBase)) {
            String configFilenamePattern = nameBase + ".yml_or_yaml_or_json";
            String configProfilePattern = nameBase + "-%s" + ".yml_or_yaml_or_json";
            ConfigUtil.load(Msc.path(config.getPath(), configFilenamePattern), config, loaded);
            for (String profile : Env.profiles()) {
                ConfigUtil.load(Msc.path(config.getPath(), U.frmt(configProfilePattern, profile)), config, loaded);
            }
        }
    }

    static void loadBuiltInConfig(Config config, List<String> loaded) {
        String nameBase = config.getFilenameBase();
        if (U.notEmpty(nameBase)) {
            ConfigUtil.load("built-in-config.yml", config, loaded);
            for (String profile : Env.profiles()) {
                String filename = U.frmt("built-in-config-%s.yml", profile);
                ConfigUtil.load(filename, config, loaded);
            }
        }
    }
}

