/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.u.U;

public class ConfigChanges
extends RapidoidThing {
    public final boolean initial;
    public final Map<String, Object> added = Coll.synchronizedMap();
    public final Map<String, Object> changed = Coll.synchronizedMap();
    public final Set<String> removed = Coll.synchronizedSet(new String[0]);
    public final List<String> keys = Coll.synchronizedList(new String[0]);

    private ConfigChanges(boolean initial) {
        this.initial = initial;
    }

    public static ConfigChanges from(List<String> keys, Map<String, Object> old, Map<String, Object> fresh, boolean initial) {
        Object newValue;
        Object oldValue;
        String key;
        ConfigChanges changes = new ConfigChanges(initial);
        Coll.assign(changes.keys, keys);
        for (Map.Entry<String, Object> e : old.entrySet()) {
            key = e.getKey();
            oldValue = e.getValue();
            newValue = fresh.get(key);
            if (ConfigChanges.isEmptyValue(oldValue)) continue;
            if (!ConfigChanges.isEmptyValue(newValue)) {
                if (!U.neq(oldValue, newValue)) continue;
                changes.changed.put(key, newValue);
                continue;
            }
            changes.removed.add(key);
        }
        for (Map.Entry<String, Object> e : fresh.entrySet()) {
            key = e.getKey();
            oldValue = old.get(key);
            newValue = fresh.get(key);
            if (ConfigChanges.isEmptyValue(newValue) || !ConfigChanges.isEmptyValue(oldValue)) continue;
            changes.added.put(key, newValue);
        }
        return changes;
    }

    private static boolean isEmptyValue(Object value) {
        return value == null || value instanceof Map && ((Map)value).isEmpty();
    }

    public int count() {
        return this.added.size() + this.changed.size() + this.removed.size();
    }

    public <T> Map<String, T> getAddedAs(Class<T> type) {
        return Coll.toBeanMap(this.added, type);
    }

    public <T> Map<String, T> getChangedAs(Class<T> type) {
        return Coll.toBeanMap(this.changed, type);
    }

    public <T> Map<String, T> getAddedOrChangedAs(Class<T> type) {
        Map<String, Object> addedOrChanged = U.map();
        addedOrChanged.putAll(this.added);
        addedOrChanged.putAll(this.changed);
        return Coll.toBeanMap(addedOrChanged, type);
    }

    public String toString() {
        return "ConfigChanges{initial=" + this.initial + ", added=" + this.added + ", changed=" + this.changed + ", removed=" + this.removed + ", keys=" + this.keys + '}';
    }
}

