/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Map;
import java.util.Set;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigChangeListener;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ConfigBase
extends RapidoidInitializer {
    private final String defaultFilenameBase;
    private final boolean useBuiltInDefaults;
    final Map<String, Object> properties = Coll.synchronizedMap();
    final Map<String, Object> initial = Coll.synchronizedMap();
    final Set<ConfigChangeListener> configChangesListeners = Coll.synchronizedSet(new ConfigChangeListener[0]);
    volatile boolean initializing;
    volatile boolean initialized;
    volatile String path = "";
    volatile String filenameBase;

    public ConfigBase(String defaultFilenameBase, boolean useBuiltInDefaults) {
        this.defaultFilenameBase = defaultFilenameBase;
        this.filenameBase = defaultFilenameBase;
        this.useBuiltInDefaults = useBuiltInDefaults;
    }

    synchronized void reset() {
        this.properties.clear();
        this.initial.clear();
        this.configChangesListeners.clear();
        this.filenameBase = this.defaultFilenameBase;
        this.path = "";
        this.initialized = false;
        this.initializing = false;
    }

    synchronized void invalidate() {
        RapidoidEnv.touch();
        this.properties.clear();
        this.initialized = false;
        this.initializing = false;
    }

    String getFilenameBase() {
        return this.filenameBase;
    }

    synchronized boolean setFilenameBase(String filenameBase) {
        RapidoidEnv.touch();
        if (U.neq(this.filenameBase, filenameBase)) {
            if (!Msc.isSilent()) {
                Log.info("Changing configuration filename base", "!from", this.filenameBase, "!to", filenameBase);
            }
            this.filenameBase = filenameBase;
            return true;
        }
        return false;
    }

    synchronized boolean setPath(String path) {
        RapidoidEnv.touch();
        if (U.neq(this.path, path)) {
            if (!Msc.isSilent()) {
                Log.info("Changing configuration path", "!from", this.path, "!to", path);
            }
            this.path = path;
            return true;
        }
        return false;
    }

    String getPath() {
        return this.path;
    }

    public boolean useBuiltInDefaults() {
        return this.useBuiltInDefaults;
    }

    void setInitial(String name, Object value) {
        this.initial.put(name, value);
    }

    synchronized void applyInitialConfig(Config config) {
        config.update(this.initial);
    }
}

