/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.log.GlobalCfg;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class RapidoidInfo
extends RapidoidThing {
    private static volatile long startedOn = System.currentTimeMillis();
    private static final Properties PROPS = new Properties();
    private static final String VERSION;
    private static final String BUILT_ON;

    public static String version() {
        return VERSION;
    }

    public static String builtOn() {
        return BUILT_ON;
    }

    public static List<String> notes() {
        List<String> notes = U.list();
        if (Msc.dockerized()) {
            notes.add("Dockerized");
        }
        if (GlobalCfg.uniformOutput()) {
            notes.add("Uniform output");
        }
        return notes;
    }

    public static String nameAndInfo() {
        String info = U.frmt("v%s, built on %s", Msc.maybeMasked(RapidoidInfo.version()), Msc.maybeMasked(RapidoidInfo.builtOn()));
        String notes = Str.render(RapidoidInfo.notes(), " [%s]", "");
        return "Rapidoid " + info + notes;
    }

    public static long uptime() {
        return U.time() - startedOn;
    }

    public static boolean isSnapshot() {
        return RapidoidInfo.version().endsWith("-SNAPSHOT");
    }

    static {
        try {
            InputStream res = Thread.currentThread().getContextClassLoader().getResourceAsStream("rapidoid.properties");
            if (res != null) {
                PROPS.load(res);
            }
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        VERSION = PROPS.getProperty("version");
        BUILT_ON = PROPS.getProperty("built-on");
    }
}

