/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.cache.impl;

import java.util.List;
import org.rapidoid.cache.impl.ConcurrentCache;
import org.rapidoid.group.Action;
import org.rapidoid.group.AutoManageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.u.U;

@ManageableBean(kind="cache")
public class ManageableCache
extends AutoManageable<ManageableCache> {
    private final ConcurrentCache<?, ?> cache;

    public ManageableCache(ConcurrentCache<?, ?> cache) {
        super(cache.name());
        this.cache = cache;
    }

    @Override
    public List<String> getManageableProperties() {
        return U.list("id", "size", "capacity", "hitRate", "hits", "misses", "bypassed", "errors", "ttl");
    }

    @Action(name="!purge")
    public void purge() {
        this.cache.clear();
    }

    public long ttl() {
        return this.cache.ttlInMs();
    }

    public long misses() {
        return this.cache.stats().misses.get();
    }

    public long hits() {
        return this.cache.stats().hits.get();
    }

    public long errors() {
        return this.cache.stats().errors.get();
    }

    public long bypassed() {
        return this.cache.stats().bypassed.get();
    }

    public String hitRate() {
        long total = this.cache.stats().total();
        return total != 0L ? (double)Math.round((double)this.hits() * 10000.0 / (double)total) / 100.0 + " %" : "";
    }

    public int size() {
        return this.cache.size();
    }

    public int capacity() {
        return this.cache.capacity();
    }
}

