/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.bytes;

import org.rapidoid.RapidoidThing;
import org.rapidoid.bytes.ByteArrayBytes;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.StringBytes;
import org.rapidoid.commons.Err;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.BufRanges;
import org.rapidoid.util.Msc;
import org.rapidoid.wrap.IntWrap;

public class BytesUtil
extends RapidoidThing {
    public static final byte[] CHARS_SWITCH_CASE = new byte[128];
    private static final String URI_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&()'*+,;=%";
    private static final boolean[] URI_ALLOWED_CHARACTER = new boolean[128];

    public static Bytes from(byte[] bytes) {
        return new ByteArrayBytes(bytes);
    }

    public static Bytes from(String s) {
        return new StringBytes(s);
    }

    public static int parseLines(Bytes bytes, BufRanges lines, IntWrap res, int start, int limit, byte end1, byte end2) {
        byte b0 = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int ret = -1;
        res.value = Integer.MIN_VALUE;
        int from = start;
        for (int i = start; i < limit; ++i) {
            int len;
            b0 = b1;
            b1 = b2;
            b2 = b3;
            b3 = bytes.get(i);
            if (b3 != 10) continue;
            if (b2 == 13) {
                len = i - from - 1;
                if (b0 == end1 && b1 == end2 && len > 0) {
                    res.value = lines.count;
                }
            } else {
                len = i - from;
                if (b1 == end1 && b2 == end2 && len > 0) {
                    res.value = lines.count;
                }
            }
            if (len == 0) {
                ret = i + 1;
                break;
            }
            lines.add(from, len);
            from = i + 1;
        }
        return ret;
    }

    public static int parseLines(Bytes bytes, BufRanges lines, int start, int limit) {
        byte b0 = 0;
        byte b1 = 0;
        int ret = -1;
        int from = start;
        for (int i = start; i < limit; ++i) {
            b0 = b1;
            b1 = bytes.get(i);
            if (b1 != 10) continue;
            int len = b0 == 13 ? i - from - 1 : i - from;
            if (len == 0) {
                ret = i + 1;
                break;
            }
            lines.add(from, len);
            from = i + 1;
        }
        return ret;
    }

    public static int parseLine(Bytes bytes, BufRange line, int start, int limit) {
        byte b0 = 0;
        byte b1 = 0;
        int ret = -1;
        for (int i = start; i < limit; ++i) {
            b0 = b1;
            b1 = bytes.get(i);
            if (b1 != 10) continue;
            int len = b0 == 13 ? i - start - 1 : i - start;
            line.set(start, len);
            ret = i + 1;
            break;
        }
        return ret;
    }

    public static BufRange getByPrefix(Bytes bytes, BufRanges ranges, byte[] prefix, boolean caseSensitive) {
        for (int i = 0; i < ranges.count; ++i) {
            if (!BytesUtil.startsWith(bytes, ranges.ranges[i], prefix, caseSensitive)) continue;
            return ranges.ranges[i];
        }
        return null;
    }

    public static String get(Bytes bytes, BufRange range) {
        return new String(BytesUtil.getBytes(bytes, range));
    }

    public static byte[] getBytes(Bytes bytes, BufRange range) {
        byte[] byteArr = new byte[range.length];
        for (int i = 0; i < byteArr.length; ++i) {
            byteArr[i] = bytes.get(range.start + i);
        }
        return byteArr;
    }

    public static int scan(Bytes bytes, int from, int to, byte value) {
        for (int i = from; i <= to; ++i) {
            if (bytes.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    public static int scanNoCase(Bytes bytes, int from, int to, byte value) {
        for (int i = from; i <= to; ++i) {
            byte b = bytes.get(i);
            if (b != value && (b < 65 || CHARS_SWITCH_CASE[b] != value)) continue;
            return i;
        }
        return -1;
    }

    public static boolean match(Bytes bytes, int start, byte[] match, int offset, int length, boolean caseSensitive) {
        boolean result = caseSensitive ? BytesUtil.matchSensitive(bytes, start, match, offset, length) : BytesUtil.matchNoCase(bytes, start, match, offset, length);
        return result;
    }

    public static boolean matchNoCase(Bytes bytes, int start, byte[] match, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            byte b = bytes.get(start + i);
            if (b == match[offset + i] || b >= 65 && CHARS_SWITCH_CASE[b] == match[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean matchSensitive(Bytes bytes, int start, byte[] match, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (bytes.get(start + i) == match[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean match(Bytes bytes, int start, byte[] match, boolean caseSensitive) {
        return BytesUtil.match(bytes, start, match, 0, match.length, caseSensitive);
    }

    public static int find(Bytes bytes, int start, int limit, byte match, boolean caseSensitive) {
        assert (start >= 0);
        assert (limit >= 0);
        if (limit - start < 1) {
            return -1;
        }
        if (caseSensitive) {
            return BytesUtil.scan(bytes, start, limit - 1, match);
        }
        return BytesUtil.scanNoCase(bytes, start, limit - 1, match);
    }

    public static int find(Bytes bytes, int start, int limit, byte[] match, boolean caseSensitive) {
        return BytesUtil.find(bytes, start, limit, match, 0, match.length, caseSensitive);
    }

    public static int find(Bytes bytes, int start, int limit, byte[] match, int offset, int length, boolean caseSensitive) {
        assert (start >= 0);
        assert (limit >= 0);
        assert (offset >= 0);
        assert (length >= 0);
        int result = caseSensitive ? BytesUtil.findSensitive(bytes, start, limit, match, offset, length) : BytesUtil.findNoCase(bytes, start, limit, match, offset, length);
        return result;
    }

    private static int findNoCase(Bytes bytes, int start, int limit, byte[] match, int offset, int length) {
        throw Err.notReady();
    }

    private static int findSensitive(Bytes bytes, int start, int limit, byte[] match, int offset, int length) {
        if (limit - start < length) {
            return -1;
        }
        int pos = start;
        int last = limit - length;
        while ((pos = BytesUtil.scan(bytes, pos, last, match[0])) >= 0) {
            if (BytesUtil.matchSensitive(bytes, pos, match, offset, length)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public static boolean matches(Bytes bytes, BufRange target, byte[] match, boolean caseSensitive) {
        if (target.length != match.length || target.start < 0 || target.last() >= bytes.limit()) {
            return false;
        }
        boolean result = BytesUtil.match(bytes, target.start, match, caseSensitive);
        return result;
    }

    public static boolean startsWith(Bytes bytes, BufRange target, byte[] match, boolean caseSensitive) {
        if (target.length < match.length || target.start < 0 || target.last() >= bytes.limit()) {
            return false;
        }
        boolean result = BytesUtil.match(bytes, target.start, match, caseSensitive);
        return result;
    }

    public static boolean containsAt(Bytes bytes, BufRange target, int offset, byte[] match, boolean caseSensitive) {
        if (offset < 0 || target.length < offset + match.length || target.start < 0 || target.last() >= bytes.limit()) {
            return false;
        }
        boolean result = BytesUtil.match(bytes, target.start + offset, match, caseSensitive);
        return result;
    }

    public static void trim(Bytes bytes, BufRange target) {
        int start;
        int len = target.length;
        int finish = start + len - 1;
        if (start < 0 || len == 0) {
            return;
        }
        for (start = target.start; start < finish && bytes.get(start) == 32; ++start) {
        }
        while (start < finish && bytes.get(finish) == 32) {
            --finish;
        }
        target.start = start;
        target.length = finish - start + 1;
    }

    public static boolean split(Bytes bytes, BufRange target, byte sep, BufRange before, BufRange after, boolean trimParts) {
        int pos = BytesUtil.find(bytes, target.start, target.limit(), sep, true);
        if (pos >= 0) {
            before.setInterval(target.start, pos);
            after.setInterval(pos + 1, target.limit());
            if (trimParts) {
                BytesUtil.trim(bytes, before);
                BytesUtil.trim(bytes, after);
            }
            return true;
        }
        before.assign(target);
        after.reset();
        if (trimParts) {
            BytesUtil.trim(bytes, before);
        }
        return false;
    }

    public static int scanUntilAndMatchPrefix(Bytes bytes, BufRange result, byte separator, int fromPos, int toPos, int searchPrefix) {
        byte b3;
        byte b2;
        byte b1;
        byte b0;
        int p = fromPos;
        if (p <= toPos) {
            b0 = bytes.get(p);
            if (b0 == separator) {
                result.set(fromPos, 0);
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b1 = bytes.get(p);
            if (b1 == separator) {
                result.set(fromPos, 1);
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b2 = bytes.get(p);
            if (b2 == separator) {
                result.set(fromPos, 2);
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b3 = bytes.get(p);
            if (b3 == separator) {
                result.set(fromPos, 3);
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        int prefix = Msc.intFrom(b0, b1, b2, b3);
        boolean matchedPrefix = prefix == searchPrefix;
        for (int i = p; i <= toPos; ++i) {
            if (bytes.get(i) != separator) continue;
            result.setInterval(fromPos, i);
            int nextPos = i + 1;
            return matchedPrefix ? -nextPos : nextPos;
        }
        result.reset();
        return Integer.MIN_VALUE;
    }

    public static int scanLnAndMatchPrefix(Bytes bytes, BufRange result, int fromPos, int toPos, int searchPrefix) {
        byte b3;
        byte b2;
        byte b1;
        byte b0;
        int p = fromPos;
        if (p <= toPos) {
            b0 = bytes.get(p);
            if (b0 == 10) {
                result.set(fromPos, 0);
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b1 = bytes.get(p);
            if (b1 == 10) {
                if (b0 == 13) {
                    result.set(fromPos, 0);
                } else {
                    result.set(fromPos, 1);
                }
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b2 = bytes.get(p);
            if (b2 == 10) {
                if (b1 == 13) {
                    result.set(fromPos, 1);
                } else {
                    result.set(fromPos, 2);
                }
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        if (++p <= toPos) {
            b3 = bytes.get(p);
            if (b3 == 10) {
                if (b2 == 13) {
                    result.set(fromPos, 2);
                } else {
                    result.set(fromPos, 3);
                }
                return p + 1;
            }
        } else {
            result.reset();
            return Integer.MIN_VALUE;
        }
        int prefix = Msc.intFrom(b0, b1, b2, b3);
        boolean matchedPrefix = prefix == searchPrefix;
        for (int i = p; i <= toPos; ++i) {
            if (bytes.get(i) != 10) continue;
            if (bytes.get(i - 1) == 13) {
                result.setInterval(fromPos, i - 1);
            } else {
                result.setInterval(fromPos, i);
            }
            int nextPos = i + 1;
            return matchedPrefix ? -nextPos : nextPos;
        }
        result.reset();
        return Integer.MIN_VALUE;
    }

    public static boolean isValidURI(Bytes bytes, BufRange uri) {
        int start = uri.start;
        int len = uri.length;
        int last = uri.last();
        if (len == 0 || bytes.get(start) != 47) {
            return false;
        }
        boolean inPath = true;
        byte prev = 47;
        for (int p = start + 1; p <= last; ++p) {
            byte b = bytes.get(p);
            if (b <= 0 || !URI_ALLOWED_CHARACTER[b]) {
                return false;
            }
            if (inPath) {
                if (b == 46 || b == 47) {
                    if (prev == b) {
                        return false;
                    }
                } else if (b == 63) {
                    inPath = false;
                }
            }
            prev = b;
        }
        return true;
    }

    public static int getIntPrefixOf(Bytes bytes, int position, int limit) {
        int p = position;
        if (p >= limit) {
            return 0;
        }
        byte b0 = bytes.get(p);
        if (++p >= limit) {
            return Msc.intFrom(b0, (byte)0, (byte)0, (byte)0);
        }
        byte b1 = bytes.get(p);
        if (++p >= limit) {
            return Msc.intFrom(b0, b1, (byte)0, (byte)0);
        }
        byte b2 = bytes.get(p);
        if (++p >= limit) {
            return Msc.intFrom(b0, b1, b2, (byte)0);
        }
        byte b3 = bytes.get(p);
        return Msc.intFrom(b0, b1, b2, b3);
    }

    static {
        for (int ch = 0; ch < 128; ++ch) {
            BytesUtil.CHARS_SWITCH_CASE[ch] = ch >= 97 && ch <= 122 ? (byte)(ch - 32) : (ch >= 65 && ch <= 90 ? (byte)(ch + 32) : (byte)ch);
            BytesUtil.URI_ALLOWED_CHARACTER[ch] = URI_CHARACTERS.indexOf(ch) >= 0;
        }
    }
}

