/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.buffer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufBytes;
import org.rapidoid.buffer.SSLDestination;
import org.rapidoid.bytes.ByteBufferBytes;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.commons.Err;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.BufRanges;
import org.rapidoid.pool.Pool;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.D;
import org.rapidoid.util.Msc;
import org.rapidoid.wrap.IntWrap;

public class MultiBuf
extends OutputStream
implements Buf,
Constants {
    private final byte[] HELPER = new byte[20];
    private final ThreadLocal<ByteBuffer> tmpBufs = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocateDirect(20480);
        }
    };
    private final BufRange HELPER_RANGE = new BufRange();
    private static final int TO_BYTES = 1;
    private static final int TO_CHANNEL = 2;
    private static final int TO_BUFFER = 3;
    private static final int TO_SSL_DEST = 4;
    private static final int NOT_RELEVANT = Integer.MIN_VALUE;
    private final Pool<ByteBuffer> bufPool;
    private final int factor;
    private final int addrMask;
    private final int singleCap;
    private ByteBuffer[] bufs = new ByteBuffer[10];
    private int bufN;
    private int shrinkN;
    private final String name;
    private int _position;
    private int _limit;
    private int _checkpoint;
    private final ByteBufferBytes singleBytes = new ByteBufferBytes();
    private final Bytes multiBytes;
    private Bytes _bytes = this.multiBytes = new BufBytes(this);
    private int _size;
    private boolean readOnly = false;

    public MultiBuf(Pool<ByteBuffer> bufPool, int factor, String name) {
        this.bufPool = bufPool;
        this.name = name;
        this.singleCap = (int)Math.pow(2.0, factor);
        this.factor = factor;
        this.addrMask = Msc.bitMask(factor);
        assert (this.invariant(true));
    }

    @Override
    public boolean isSingle() {
        assert (this.invariant(false));
        return this.bufN == 1;
    }

    @Override
    public byte get(int position) {
        assert (this.invariant(false));
        assert (position >= 0);
        this.validatePos(position, 1);
        ByteBuffer buf = this.bufs[(position += this.shrinkN) >> this.factor];
        assert (buf != null);
        assert (this.invariant(false));
        return buf.get(position & this.addrMask);
    }

    private void validatePos(int pos, int space) {
        boolean hasEnough;
        if (pos < 0) {
            throw U.rte("Invalid position: " + pos);
        }
        int least = pos + space;
        boolean bl = hasEnough = least <= this._size() && least <= this._limit;
        if (!hasEnough) {
            throw INCOMPLETE_READ;
        }
    }

    @Override
    public void put(int position, byte value) {
        assert (this.invariant(true));
        assert (position >= 0);
        this.validatePos(position, 1);
        ByteBuffer buf = this.bufs[(position += this.shrinkN) >> this.factor];
        assert (buf != null);
        buf.put(position & this.addrMask, value);
        assert (this.invariant(true));
    }

    @Override
    public int size() {
        assert (this.invariant(false));
        assert (this._size == this._size());
        return this._size;
    }

    private int _size() {
        return this.bufN > 0 ? (this.bufN - 1) * this.singleCap + this.bufs[this.bufN - 1].position() - this.shrinkN : 0;
    }

    private void expandUnit() {
        if (this.bufN == this.bufs.length) {
            this.bufs = (ByteBuffer[])Msc.expand(this.bufs, 2);
        }
        this.bufs[this.bufN] = this.bufPool.get();
        this.bufs[this.bufN].clear();
        ++this.bufN;
    }

    @Override
    public void append(byte value) {
        assert (this.invariant(true));
        this.writableBuf().put(value);
        this.sizeChanged();
        assert (this.invariant(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int append(ReadableByteChannel channel) throws IOException {
        assert (this.invariant(true));
        int totalRead = 0;
        try {
            int space;
            int read;
            boolean done;
            do {
                ByteBuffer dest = this.writableBuf();
                space = dest.remaining();
                assert (space > 0);
                read = channel.read(dest);
                if (read >= 0) {
                    totalRead += read;
                    continue;
                }
                this.removeLastBufferIfEmpty();
                this.sizeChanged();
                assert (this.invariant(true));
                int n = -1;
                return n;
            } while (!(done = read < space));
        }
        finally {
            this.removeLastBufferIfEmpty();
            this.sizeChanged();
            assert (this.invariant(true));
        }
        return totalRead;
    }

    @Override
    public void append(ByteBuffer src) {
        assert (this.invariant(true));
        int theLimit = src.limit();
        while (src.hasRemaining()) {
            ByteBuffer dest = this.writableBuf();
            int space = dest.remaining();
            assert (space > 0);
            if (src.remaining() > space) {
                src.limit(src.position() + space);
            }
            dest.put(src);
            src.limit(theLimit);
        }
        this.sizeChanged();
        assert (this.invariant(true));
    }

    @Override
    public void append(byte[] src, int offset, int length) {
        assert (this.invariant(true));
        int sizeBefore = this._size();
        if (length > 0) {
            ByteBuffer buf = this.writableBuf();
            if (length <= buf.remaining()) {
                buf.put(src, offset, length);
            } else {
                int partLen = buf.remaining();
                buf.put(src, offset, partLen);
                assert (buf.remaining() == 0);
                this.append(src, offset + partLen, length - partLen);
            }
        }
        this.sizeChanged();
        assert (this._size() - sizeBefore == length);
        assert (this.invariant(true));
    }

    private ByteBuffer writableBuf() {
        if (this.bufN == 0) {
            this.expandUnit();
            return this.last();
        }
        ByteBuffer cbuf = this.last();
        if (!cbuf.hasRemaining()) {
            this.expandUnit();
            cbuf = this.last();
        }
        assert (cbuf.hasRemaining());
        return cbuf;
    }

    private ByteBuffer last() {
        assert (this.bufN > 0);
        return this.bufs[this.bufN - 1];
    }

    @Override
    public ByteBuffer first() {
        assert (this.invariant(false));
        assert (this.bufN > 0);
        return this.bufs[0];
    }

    @Override
    public ByteBuffer bufAt(int index) {
        assert (this.invariant(false));
        assert (this.bufN > index);
        return this.bufs[index];
    }

    @Override
    public int append(String s) {
        assert (this.invariant(true));
        byte[] bytes = s.getBytes();
        this.append(bytes);
        this.sizeChanged();
        assert (this.invariant(true));
        return bytes.length;
    }

    public String toString() {
        return String.format("Buf " + this.name + " [size=" + this._size() + ", units=" + this.unitCount() + ", trash=" + this.shrinkN + ", pos=" + this.position() + ", limit=" + this.limit() + "] " + super.toString(), new Object[0]);
    }

    @Override
    public String data() {
        assert (this.invariant(false));
        byte[] bytes = new byte[this._size()];
        int total = this.readAll(bytes, 0, 0, bytes.length);
        assert (total == bytes.length);
        assert (this.invariant(false));
        return new String(bytes);
    }

    @Override
    public String get(BufRange range) {
        assert (this.invariant(false));
        if (range.isEmpty()) {
            return "";
        }
        byte[] bytes = new byte[range.length];
        int total = this.readAll(bytes, 0, range.start, range.length);
        assert (total == bytes.length);
        assert (this.invariant(false));
        return new String(bytes);
    }

    @Override
    public void get(BufRange range, byte[] dest, int offset) {
        assert (this.invariant(false));
        int total = this.readAll(dest, offset, range.start, range.length);
        assert (total == range.length);
        assert (this.invariant(false));
    }

    private int writeToHelper(BufRange range) {
        assert (this.invariant(false));
        return this.readAll(this.HELPER, 0, range.start, range.length);
    }

    private int readAll(byte[] bytes, int destOffset, int offset, int length) {
        int wrote;
        assert (this.invariant(false));
        if (offset + length > this._size()) {
            throw new IllegalArgumentException("offset + length > buffer size!");
        }
        try {
            wrote = this.writeTo(1, offset, length, bytes, null, null, null, destOffset);
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        assert (this.invariant(false));
        return wrote;
    }

    @Override
    public int writeTo(WritableByteChannel channel) throws IOException {
        return this.writeTo(channel, 0, this._size());
    }

    @Override
    public int writeTo(WritableByteChannel channel, int srcOffset, int length) throws IOException {
        assert (this.invariant(false));
        int wrote = this.writeTo(2, srcOffset, length, null, channel, null, null, Integer.MIN_VALUE);
        assert (U.must(wrote <= this._size(), "Incorrect write to channel!"));
        assert (this.invariant(false));
        return wrote;
    }

    @Override
    public int writeTo(ByteBuffer buffer) {
        return this.writeTo(buffer, 0, this._size());
    }

    @Override
    public int writeTo(ByteBuffer buffer, int srcOffset, int length) {
        assert (this.invariant(false));
        try {
            int wrote = this.writeTo(3, srcOffset, length, null, null, buffer, null, Integer.MIN_VALUE);
            assert (wrote == length);
            assert (this.invariant(false));
            return wrote;
        }
        catch (IOException e) {
            assert (this.invariant(false));
            throw U.rte(e);
        }
    }

    private int writeTo(int mode, int offset, int length, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, SSLDestination sslDest, int destOffset) throws IOException {
        if (this._size() == 0) {
            assert (length == 0);
            return 0;
        }
        int fromPos = offset + this.shrinkN;
        int toPos = fromPos + length - 1;
        int fromInd = fromPos >> this.factor;
        int toInd = toPos >> this.factor;
        int fromAddr = fromPos & this.addrMask;
        int toAddr = toPos & this.addrMask;
        assert (fromInd <= toInd);
        if (fromInd == toInd) {
            return this.writePart(this.bufs[fromInd], fromAddr, toAddr + 1, mode, bytes, channel, buffer, sslDest, destOffset, -1);
        }
        return this.multiWriteTo(mode, fromInd, toInd, fromAddr, toAddr, bytes, channel, buffer, sslDest, destOffset);
    }

    private int multiWriteTo(int mode, int fromIndex, int toIndex, int fromAddr, int toAddr, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, SSLDestination sslDest, int destOffset) throws IOException {
        ByteBuffer first = this.bufs[fromIndex];
        int len = this.singleCap - fromAddr;
        int wrote = this.writePart(first, fromAddr, this.singleCap, mode, bytes, channel, buffer, sslDest, destOffset, len);
        if (wrote < len) {
            return wrote;
        }
        int wroteTotal = wrote;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            wrote = this.writePart(this.bufs[i], 0, this.singleCap, mode, bytes, channel, buffer, sslDest, destOffset + wroteTotal, this.singleCap);
            wroteTotal += wrote;
            if (wrote >= this.singleCap) continue;
            return wroteTotal;
        }
        ByteBuffer last = this.bufs[toIndex];
        wroteTotal += this.writePart(last, 0, toAddr + 1, mode, bytes, channel, buffer, sslDest, destOffset + wroteTotal, toAddr + 1);
        return wroteTotal;
    }

    private int writePart(ByteBuffer src, int pos, int limit, int mode, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, SSLDestination sslDest, int destOffset, int len) throws IOException {
        int count;
        int posBackup = src.position();
        int limitBackup = src.limit();
        src.position(pos);
        src.limit(limit);
        assert (src.remaining() == len || len < 0);
        block1 : switch (mode) {
            case 1: {
                if (len >= 0) {
                    src.get(bytes, destOffset, len);
                    count = len;
                    break;
                }
                count = src.remaining();
                src.get(bytes, destOffset, count);
                break;
            }
            case 2: {
                count = 0;
                while (src.hasRemaining()) {
                    int wrote = channel.write(src);
                    count += wrote;
                    if (wrote != 0) continue;
                    break block1;
                }
                break;
            }
            case 3: {
                count = src.remaining();
                buffer.put(src);
                break;
            }
            case 4: {
                count = 0;
                ByteBuffer tmpBuf = this.tmpBufs.get();
                while (src.hasRemaining()) {
                    SSLEngineResult result;
                    tmpBuf.clear();
                    try {
                        result = sslDest.engine.wrap(src, tmpBuf);
                    }
                    catch (SSLException e) {
                        throw U.rte(e);
                    }
                    tmpBuf.flip();
                    sslDest.dest.append(tmpBuf);
                    count += result.bytesConsumed();
                }
                break;
            }
            default: {
                throw Err.notExpected();
            }
        }
        src.limit(limitBackup);
        src.position(posBackup);
        return count;
    }

    private boolean invariant(boolean writing) {
        if (this.readOnly) assert (!writing);
        try {
            assert (this.bufN >= 0);
            for (int i = 0; i < this.bufN - 1; ++i) {
                ByteBuffer buf = this.bufs[i];
                assert (buf.position() == this.singleCap);
                assert (buf.limit() == this.singleCap);
                assert (buf.capacity() == this.singleCap);
            }
            if (this.bufN > 0) {
                ByteBuffer buf = this.bufs[this.bufN - 1];
                assert (buf == this.last());
                assert (buf.position() > 0);
                assert (buf.capacity() == this.singleCap);
            }
            return true;
        }
        catch (AssertionError e) {
            this.dumpBuffers();
            throw e;
        }
    }

    private void dumpBuffers() {
        U.print(">> BUFFER " + this.name + " HAS " + this.bufN + " PARTS:");
        for (int i = 0; i < this.bufN - 1; ++i) {
            ByteBuffer buf = this.bufs[i];
            D.print(i + "]" + buf);
        }
        if (this.bufN > 0) {
            ByteBuffer buf = this.bufs[this.bufN - 1];
            D.print("LAST]" + buf);
        }
    }

    @Override
    public void deleteBefore(int count) {
        assert (this.invariant(true));
        if (count == this._size()) {
            this.clear();
            return;
        }
        this.shrinkN += count;
        while (this.shrinkN >= this.singleCap) {
            this.removeFirstBuf();
            this.shrinkN -= this.singleCap;
        }
        this._position -= count;
        if (this._position < 0) {
            this._position = 0;
        }
        this.sizeChanged();
        assert (this.invariant(true));
    }

    private void removeFirstBuf() {
        this.bufs[0].clear();
        this.bufPool.release(this.bufs[0]);
        for (int i = 0; i < this.bufN - 1; ++i) {
            this.bufs[i] = this.bufs[i + 1];
        }
        --this.bufN;
    }

    private void removeLastBuf() {
        this.bufs[this.bufN - 1].clear();
        this.bufPool.release(this.bufs[this.bufN - 1]);
        --this.bufN;
        if (this.bufN == 0) {
            this.shrinkN = 0;
        }
    }

    private void removeLastBufferIfEmpty() {
        if (this.bufN > 0 && this.last().position() == 0) {
            this.removeLastBuf();
        }
    }

    @Override
    public int unitCount() {
        assert (this.invariant(false));
        return this.bufN;
    }

    @Override
    public int unitSize() {
        assert (this.invariant(false));
        return this.singleCap;
    }

    @Override
    public void put(int position, byte[] bytes, int offset, int length) {
        assert (this.invariant(true));
        int pos = position;
        for (int i = offset; i < offset + length; ++i) {
            this.put(pos++, bytes[i]);
        }
        assert (this.invariant(true));
    }

    @Override
    public void append(byte[] bytes) {
        assert (this.invariant(true));
        this.append(bytes, 0, bytes.length);
        assert (this.invariant(true));
    }

    @Override
    public void deleteAfter(int position) {
        assert (this.invariant(true));
        if (this.bufN == 0 || position == this._size()) {
            assert (this.invariant(true));
            return;
        }
        assert (this.validPosition(position));
        if (this.bufN == 1) {
            int newPos = position + this.shrinkN;
            assert (newPos <= this.singleCap);
            this.first().position(newPos);
            if (newPos == 0) {
                this.removeLastBuf();
            }
        } else {
            int index = (position += this.shrinkN) >> this.factor;
            int addr = position & this.addrMask;
            while (index < this.bufN - 1) {
                this.removeLastBuf();
            }
            ByteBuffer last = this.bufs[index];
            assert (this.last() == last);
            if (addr > 0) {
                last.position(addr);
            } else {
                this.removeLastBuf();
                if (this.bufN > 0) {
                    this.last().position(this.singleCap);
                }
            }
        }
        this.removeLastBufferIfEmpty();
        this.sizeChanged();
        assert (this.invariant(true));
    }

    @Override
    public void deleteLast(int count) {
        assert (this.invariant(true));
        this.deleteAfter(this._size() - count);
        assert (this.invariant(true));
    }

    private boolean validPosition(int position) {
        assert (U.must(position >= 0 && position < this._size(), "Invalid position: %s", position));
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bufN; ++i) {
            this.bufs[i].clear();
            this.bufPool.release(this.bufs[i]);
        }
        this.readOnly = false;
        this.shrinkN = 0;
        this.bufN = 0;
        this._position = 0;
        this.sizeChanged();
        assert (this.invariant(true));
    }

    @Override
    public long getN(BufRange range) {
        int start;
        assert (this.invariant(false));
        assert (range.length >= 1);
        if (range.length > 20) {
            assert (this.invariant(false));
            throw U.rte("Too many digits!");
        }
        int count = this.writeToHelper(range);
        int value = 0;
        boolean negative = this.HELPER[0] == 45;
        for (int i = start = negative ? 1 : 0; i < count; ++i) {
            byte b = this.HELPER[i];
            if (b < 48 || b > 57) {
                assert (this.invariant(false));
                throw U.rte("Invalid number: '%s'", this.get(range));
            }
            int digit = b - 48;
            value = value * 10 + digit;
        }
        assert (this.invariant(false));
        return negative ? (long)(-value) : (long)value;
    }

    @Override
    public ByteBuffer getSingle() {
        assert (this.invariant(false));
        return this.isSingle() ? this.first() : null;
    }

    @Override
    public int putNumAsText(int position, long n, boolean forward) {
        int space;
        boolean appending;
        int direction;
        assert (this.invariant(true));
        if (forward) {
            direction = 0;
            appending = position == this.size();
        } else {
            direction = -1;
            appending = false;
        }
        if (n >= 0L) {
            if (n < 10L) {
                if (appending) {
                    this.append((byte)(n + 48L));
                } else {
                    this.put(position, (byte)(n + 48L));
                }
                space = 1;
            } else if (n < 100L) {
                long dig1 = n / 10L;
                long dig2 = n % 10L;
                if (appending) {
                    this.append((byte)(dig1 + 48L));
                    this.append((byte)(dig2 + 48L));
                } else {
                    this.put(position + direction, (byte)(dig1 + 48L));
                    this.put(position + direction + 1, (byte)(dig2 + 48L));
                }
                space = 2;
            } else if (appending) {
                String nums = "" + n;
                this.append(nums.getBytes());
                space = nums.length();
            } else {
                int digitsN = (int)Math.ceil(Math.log10(n + 1L));
                int pos = position + digitsN - 1 + direction * digitsN;
                if (!forward) {
                    // empty if block
                }
                while (true) {
                    long digit = n % 10L;
                    byte dig = (byte)(digit + 48L);
                    int n2 = ++pos;
                    --pos;
                    this.put(n2, dig);
                    if (n < 10L) break;
                    n /= 10L;
                }
                space = digitsN;
            }
        } else if (forward) {
            this.put(position, (byte)45);
            space = this.putNumAsText(position + 1, -n, forward) + 1;
        } else {
            int digits = this.putNumAsText(position, -n, forward);
            this.put(position - digits, (byte)45);
            space = digits + 1;
        }
        assert (this.invariant(true));
        return space;
    }

    private int rebase(int pos, int bufInd) {
        return (bufInd << this.factor) + pos - this.shrinkN;
    }

    @Override
    public byte next() {
        assert (this.invariant(false));
        byte b = this.get(this._position++);
        assert (this.invariant(false));
        return b;
    }

    @Override
    public void back(int count) {
        assert (this.invariant(false));
        --this._position;
        assert (this.invariant(false));
    }

    @Override
    public byte peek() {
        assert (this.invariant(false));
        byte b = this.get(this._position);
        assert (this.invariant(false));
        return b;
    }

    @Override
    public boolean hasRemaining() {
        boolean result;
        assert (this.invariant(false));
        boolean bl = result = this.remaining() > 0;
        assert (this.invariant(false));
        return result;
    }

    @Override
    public int remaining() {
        assert (this.invariant(false));
        return this._limit - this._position;
    }

    @Override
    public int position() {
        assert (this.invariant(false));
        return this._position;
    }

    @Override
    public int limit() {
        assert (this.invariant(false));
        return this._limit;
    }

    private void sizeChanged() {
        this._size = this._size();
        this._limit = this._size();
        if (this.bufN == 1) {
            this.singleBytes.setTarget(this.bufs[0], this.shrinkN, this._limit);
            this._bytes = this.singleBytes;
        } else {
            this._bytes = this.multiBytes;
        }
    }

    @Override
    public void position(int position) {
        assert (this.invariant(false));
        this._position = position;
        assert (this.invariant(false));
    }

    @Override
    public void limit(int limit) {
        assert (this.invariant(false));
        this._limit = limit;
        assert (this.invariant(false));
    }

    @Override
    public void upto(byte value, BufRange range) {
        assert (this.invariant(false));
        range.starts(this._position);
        while (this.get(this._position) != value) {
            ++this._position;
        }
        range.ends(this._position);
        ++this._position;
        assert (this.invariant(false));
    }

    @Override
    public ByteBuffer exposed() {
        assert (this.invariant(false));
        ByteBuffer first = this.first();
        assert (this.invariant(false));
        return first;
    }

    @Override
    public void scanUntil(byte value, BufRange range) {
        byte b;
        int pos;
        assert (this.invariant(false));
        this.requireRemaining(1);
        int start = this.position();
        int limit = this.limit();
        int last = limit - 1;
        int fromPos = start + this.shrinkN;
        int toPos = last + this.shrinkN;
        int fromInd = fromPos >> this.factor;
        int toInd = toPos >> this.factor;
        int fromAddr = fromPos & this.addrMask;
        int toAddr = toPos & this.addrMask;
        assert (U.must(fromInd >= 0, "bad start: %s", start));
        assert (U.must(toInd >= 0, "bad end: %s", last));
        ByteBuffer src = this.bufs[fromInd];
        int absPos = start;
        for (pos = fromAddr; pos < this.singleCap; ++pos) {
            b = src.get(pos);
            if (b == value) {
                range.setInterval(start, absPos);
                this.position(absPos + 1);
                assert (this.invariant(false));
                return;
            }
            ++absPos;
        }
        for (int i = fromInd + 1; i < toInd; ++i) {
            src = this.bufs[i];
            for (int pos2 = 0; pos2 < this.singleCap; ++pos2) {
                byte b2 = src.get(pos2);
                if (b2 == value) {
                    range.setInterval(start, absPos);
                    this.position(absPos + 1);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        if (fromInd < toInd) {
            src = this.bufs[toInd];
            for (pos = 0; pos <= toAddr; ++pos) {
                b = src.get(pos);
                if (b == value) {
                    range.setInterval(start, absPos);
                    this.position(absPos + 1);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        this.position(limit);
        assert (this.invariant(false));
        throw INCOMPLETE_READ;
    }

    @Override
    public void scanWhile(byte value, BufRange range) {
        byte b;
        int pos;
        assert (this.invariant(false));
        this.requireRemaining(1);
        int start = this.position();
        int limit = this.limit();
        int last = limit - 1;
        int fromPos = start + this.shrinkN;
        int toPos = last + this.shrinkN;
        int fromInd = fromPos >> this.factor;
        int toInd = toPos >> this.factor;
        int fromAddr = fromPos & this.addrMask;
        int toAddr = toPos & this.addrMask;
        assert (U.must(fromInd >= 0, "bad start: %s", start));
        assert (U.must(toInd >= 0, "bad end: %s", last));
        ByteBuffer src = this.bufs[fromInd];
        int absPos = start;
        for (pos = fromAddr; pos < this.singleCap; ++pos) {
            b = src.get(pos);
            if (b != value) {
                range.setInterval(start, absPos);
                this.position(absPos);
                assert (this.invariant(false));
                return;
            }
            ++absPos;
        }
        for (int i = fromInd + 1; i < toInd; ++i) {
            src = this.bufs[i];
            for (int pos2 = 0; pos2 < this.singleCap; ++pos2) {
                byte b2 = src.get(pos2);
                if (b2 != value) {
                    range.setInterval(start, absPos);
                    this.position(absPos);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        if (fromInd < toInd) {
            src = this.bufs[toInd];
            for (pos = 0; pos <= toAddr; ++pos) {
                b = src.get(pos);
                if (b != value) {
                    range.setInterval(start, absPos);
                    this.position(absPos);
                    assert (this.invariant(false));
                    return;
                }
                ++absPos;
            }
        }
        this.position(limit);
        assert (this.invariant(false));
        throw INCOMPLETE_READ;
    }

    private void requireRemaining(int n) {
        if (this.remaining() < n) {
            throw Buf.INCOMPLETE_READ;
        }
    }

    @Override
    public void skip(int count) {
        assert (this.invariant(false));
        this.requireRemaining(count);
        this._position += count;
        assert (this.invariant(false));
    }

    @Override
    public int bufferIndexOf(int position) {
        assert (this.invariant(false));
        assert (position >= 0);
        this.validatePos(position, 1);
        int index = (position += this.shrinkN) >> this.factor;
        assert (this.bufs[index] != null);
        assert (this.invariant(false));
        return index;
    }

    @Override
    public int bufferOffsetOf(int position) {
        assert (this.invariant(false));
        assert (position >= 0);
        this.validatePos(position, 1);
        position += this.shrinkN;
        assert (this.invariant(false));
        return position & this.addrMask;
    }

    @Override
    public int bufCount() {
        assert (this.invariant(false));
        return this.bufN;
    }

    @Override
    public OutputStream asOutputStream() {
        return this;
    }

    @Override
    public String asText() {
        return this.get(new BufRange(0, this.size()));
    }

    @Override
    public Bytes bytes() {
        assert (this.invariant(false));
        return this._bytes;
    }

    @Override
    public void scanLn(BufRange line) {
        assert (this.invariant(false));
        int pos = BytesUtil.parseLine(this.bytes(), line, this.position(), this.size());
        if (pos < 0) {
            assert (this.invariant(false));
            throw INCOMPLETE_READ;
        }
        this._position = pos;
        assert (this.invariant(false));
    }

    @Override
    public void scanLnLn(BufRanges lines) {
        assert (this.invariant(false));
        int pos = BytesUtil.parseLines(this.bytes(), lines, this.position(), this.size());
        if (pos < 0) {
            assert (this.invariant(false));
            throw INCOMPLETE_READ;
        }
        this._position = pos;
        assert (this.invariant(false));
    }

    @Override
    public void scanN(int count, BufRange range) {
        assert (this.invariant(false));
        this.get(this._position + count - 1);
        range.set(this._position, count);
        this._position += count;
        assert (this.invariant(false));
    }

    @Override
    public String readLn() {
        assert (this.invariant(false));
        this.scanLn(this.HELPER_RANGE);
        String result = this.get(this.HELPER_RANGE);
        assert (this.invariant(false));
        return result;
    }

    @Override
    public String readN(int count) {
        assert (this.invariant(false));
        this.scanN(count, this.HELPER_RANGE);
        String result = this.get(this.HELPER_RANGE);
        assert (this.invariant(false));
        return result;
    }

    @Override
    public byte[] readNbytes(int count) {
        assert (this.invariant(false));
        this.scanN(count, this.HELPER_RANGE);
        byte[] bytes = new byte[count];
        this.get(this.HELPER_RANGE, bytes, 0);
        assert (this.invariant(false));
        return bytes;
    }

    @Override
    public void scanTo(byte sep, BufRange range, boolean failOnLimit) {
        assert (this.invariant(false));
        int pos = BytesUtil.find(this.bytes(), this._position, this._limit, sep, true);
        if (pos >= 0) {
            this.consumeAndSkip(pos, range, 1);
        } else {
            if (failOnLimit) {
                assert (this.invariant(false));
                throw INCOMPLETE_READ;
            }
            this.consumeAndSkip(this._limit, range, 0);
        }
        assert (this.invariant(false));
    }

    @Override
    public int scanTo(byte sep1, byte sep2, BufRange range, boolean failOnLimit) {
        boolean found2;
        assert (this.invariant(false));
        int pos1 = BytesUtil.find(this.bytes(), this._position, this._limit, sep1, true);
        int pos2 = BytesUtil.find(this.bytes(), this._position, this._limit, sep2, true);
        boolean found1 = pos1 >= 0;
        boolean bl = found2 = pos2 >= 0;
        if (found1 && found2) {
            if (pos1 <= pos2) {
                this.consumeAndSkip(pos1, range, 1);
                assert (this.invariant(false));
                return 1;
            }
            this.consumeAndSkip(pos2, range, 1);
            assert (this.invariant(false));
            return 2;
        }
        if (found1 && !found2) {
            this.consumeAndSkip(pos1, range, 1);
            assert (this.invariant(false));
            return 1;
        }
        if (!found1 && found2) {
            this.consumeAndSkip(pos2, range, 1);
            assert (this.invariant(false));
            return 2;
        }
        if (failOnLimit) {
            assert (this.invariant(false));
            throw INCOMPLETE_READ;
        }
        this.consumeAndSkip(this._limit, range, 0);
        assert (this.invariant(false));
        return 0;
    }

    private void consumeAndSkip(int toPos, BufRange range, int skip) {
        range.setInterval(this._position, toPos);
        this._position = toPos + skip;
    }

    @Override
    public void scanLnLn(BufRanges ranges, IntWrap result, byte end1, byte end2) {
        assert (this.invariant(false));
        int nextPos = BytesUtil.parseLines(this.bytes(), ranges, result, this._position, this._limit, end1, end2);
        if (nextPos < 0) {
            throw Buf.INCOMPLETE_READ;
        }
        this._position = nextPos;
        assert (this.invariant(false));
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public int checkpoint() {
        return this._checkpoint;
    }

    @Override
    public void checkpoint(int checkpoint) {
        this._checkpoint = checkpoint;
    }

    @Override
    public void write(int byteValue) throws IOException {
        this.append((byte)byteValue);
    }

    @Override
    public void write(byte[] src, int off, int len) {
        this.append(src, off, len);
    }

    @Override
    public Buf unwrap() {
        return this;
    }

    @Override
    public void append(ByteArrayOutputStream src) {
        try {
            src.writeTo(this.asOutputStream());
        }
        catch (IOException e) {
            throw U.rte(e);
        }
    }

    @Override
    public int sslWrap(SSLEngine engine, Buf dest) {
        int consumed;
        assert (this.invariant(false));
        SSLDestination sslDest = new SSLDestination(engine, dest);
        try {
            consumed = this.writeTo(4, 0, this._size(), null, null, null, sslDest, Integer.MIN_VALUE);
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        assert (U.must(consumed <= this._size(), "Incorrect write to channel!"));
        this.deleteBefore(consumed);
        assert (this.invariant(false));
        return consumed;
    }

    @Override
    public void writeByte(byte byteValue) {
        this.append(byteValue);
    }

    @Override
    public void writeBytes(byte[] src) {
        this.append(src);
    }

    @Override
    public void writeBytes(byte[] src, int offset, int length) {
        this.append(src, offset, length);
    }
}

