/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.activity;

import java.util.concurrent.CancellationException;
import org.rapidoid.activity.LifecycleActivity;
import org.rapidoid.activity.RapidoidThread;
import org.rapidoid.log.Log;

public abstract class AbstractThreadActivity<T>
extends LifecycleActivity<T>
implements Runnable {
    protected final Thread thread;

    public AbstractThreadActivity(String name) {
        super(name);
        this.thread = new RapidoidThread(this, name);
    }

    @Override
    public T start() {
        this.checkActive(false);
        this.thread.start();
        return super.start();
    }

    @Override
    public T halt() {
        this.checkActive(true);
        this.thread.stop();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return super.halt();
    }

    @Override
    public T shutdown() {
        this.checkActive(true);
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return super.shutdown();
    }

    @Override
    public final void run() {
        Log.info("Starting activity thread", "name", this.name);
        try {
            while (!Thread.interrupted()) {
                try {
                    this.loop();
                }
                catch (CancellationException e) {
                    Log.info("Interrupted activity thread", "name", this.name);
                    return;
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }
        }
        catch (ThreadDeath e) {
            Log.info("Halted activity thread", "name", this.name);
            return;
        }
        Log.info("Finished activity thread", "name", this.name);
    }

    protected void onError(Exception e) {
        Log.error("Activity error!", "activity", this.name, "error", e);
    }

    protected abstract void loop();
}

