/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.rapidoid.RapidoidModule;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.u.U;

public class RapidoidModules
extends RapidoidThing {
    private static final Comparator<RapidoidModule> MODULE_COMPARATOR = new Comparator<RapidoidModule>(){

        @Override
        public int compare(RapidoidModule mod1, RapidoidModule mod2) {
            return mod1.order() - mod2.order();
        }
    };

    public static List<RapidoidModule> getAll() {
        return RapidoidModules.all(false);
    }

    public static List<RapidoidModule> getAllAvailable() {
        return RapidoidModules.all(true);
    }

    public static List<RapidoidModule> all(boolean availableOnly) {
        List<RapidoidModule> modules = U.list();
        RapidoidModules.addServiceLoaderModules(availableOnly, modules);
        RapidoidModules.addBuiltInModules(modules);
        RapidoidModules.validate(modules);
        Collections.sort(modules, MODULE_COMPARATOR);
        return modules;
    }

    private static void addBuiltInModules(List<RapidoidModule> modules) {
        for (String clsName : Cls.getRapidoidClasses()) {
            Class cls;
            boolean isModule;
            if (!clsName.endsWith("Module") || !(isModule = (cls = Cls.getClassIfExists(clsName)) != null && !cls.isInterface() && RapidoidModule.class.isAssignableFrom(cls) && !Modifier.isAbstract(cls.getModifiers()))) continue;
            modules.add((RapidoidModule)Cls.newInstance(cls));
        }
    }

    private static void addServiceLoaderModules(boolean availableOnly, List<RapidoidModule> modules) {
        Iterator<RapidoidModule> it = ServiceLoader.load(RapidoidModule.class).iterator();
        while (it.hasNext()) {
            RapidoidModule mod;
            if (availableOnly) {
                try {
                    mod = it.next();
                }
                catch (ServiceConfigurationError e) {
                    mod = null;
                }
            } else {
                mod = it.next();
            }
            if (mod == null) continue;
            modules.add(mod);
        }
    }

    private static void validate(List<RapidoidModule> modules) {
        for (RapidoidModule module : modules) {
            U.notNull(module.name(), "the name of module %s", module.getClass().getSimpleName());
        }
    }
}

