/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.testservice;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ForbiddenException;
import io.scalecube.services.testservice.AuthRegistry;
import reactor.core.publisher.Mono;

public class SecuredAuthenticator
implements Authenticator<String> {
    private final AuthRegistry authRegistry;

    public SecuredAuthenticator(AuthRegistry authRegistry) {
        this.authRegistry = authRegistry;
    }

    public Mono<String> authenticate(ServiceMessage message) {
        String sessionId = message.header("SESSION_ID");
        return sessionId == null ? Mono.error((Throwable)new BadRequestException("No session id provided in request")) : this.authRegistry.getAuth(Long.parseLong(sessionId)).map(Mono::just).orElse(Mono.error((Throwable)new ForbiddenException("Session is not authenticated")));
    }
}

