/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.testservice;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AuthRegistry {
    static final String SESSION_ID = "SESSION_ID";
    private final Set<String> allowedUsers;
    private ConcurrentMap<Long, String> loggedInUsers = new ConcurrentHashMap<Long, String>();

    public AuthRegistry(Set<String> allowedUsers) {
        this.allowedUsers = allowedUsers;
    }

    public Optional<String> getAuth(long sessionId) {
        return Optional.ofNullable(this.loggedInUsers.get(sessionId));
    }

    public Optional<String> addAuth(long sessionId, String auth) {
        if (this.allowedUsers.contains(auth)) {
            this.loggedInUsers.putIfAbsent(sessionId, auth);
            return Optional.of(auth);
        }
        System.err.println("User not in list of ALLOWED: " + auth);
        return Optional.empty();
    }

    public String removeAuth(long sessionId) {
        return (String)this.loggedInUsers.remove(sessionId);
    }
}

