/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway.transport.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.gateway.transport.GatewayClient;
import io.scalecube.services.gateway.transport.GatewayClientCodec;
import io.scalecube.services.gateway.transport.GatewayClientSettings;
import io.scalecube.services.gateway.transport.websocket.Signal;
import io.scalecube.services.gateway.transport.websocket.WebsocketSession;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.LoopResources;

public final class WebsocketGatewayClient
implements GatewayClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketGatewayClient.class);
    private static final String STREAM_ID = "sid";
    private static final String SIGNAL = "sig";
    private static final AtomicReferenceFieldUpdater<WebsocketGatewayClient, Mono> websocketMonoUpdater = AtomicReferenceFieldUpdater.newUpdater(WebsocketGatewayClient.class, Mono.class, "websocketMono");
    private final GatewayClientCodec<ByteBuf> codec;
    private final GatewayClientSettings settings;
    private final HttpClient httpClient;
    private final AtomicLong sidCounter = new AtomicLong();
    private final LoopResources loopResources;
    private final MonoProcessor<Void> close = MonoProcessor.create();
    private final MonoProcessor<Void> onClose = MonoProcessor.create();
    private volatile Mono<?> websocketMono;

    public WebsocketGatewayClient(GatewayClientSettings settings, GatewayClientCodec<ByteBuf> codec) {
        this.settings = settings;
        this.codec = codec;
        this.loopResources = LoopResources.create((String)"websocket-gateway-client");
        this.httpClient = HttpClient.newConnection().followRedirect(settings.followRedirect()).tcpConfiguration(tcpClient -> {
            if (settings.sslProvider() != null) {
                tcpClient = tcpClient.secure(settings.sslProvider());
            }
            return tcpClient.wiretap(settings.wiretap()).runOn(this.loopResources).host(settings.host()).port(settings.port());
        });
        this.close.then(this.doClose()).doFinally(s -> this.onClose.onComplete()).doOnTerminate(() -> LOGGER.info("Closed WebsocketGatewayClient resources")).subscribe(null, ex -> LOGGER.warn("Exception occurred on WebsocketGatewayClient close: " + ex));
    }

    @Override
    public Mono<ServiceMessage> requestResponse(ServiceMessage request) {
        return Mono.defer(() -> {
            long sid = this.sidCounter.incrementAndGet();
            return this.getOrConnect().flatMap(session -> session.send(this.encodeRequest(request, sid), sid).doOnSubscribe(s -> LOGGER.debug("Sending request {}", (Object)request)).then(session.newMonoProcessor(sid)).doOnCancel(() -> this.handleCancel(sid, (WebsocketSession)session)).doFinally(s -> session.removeProcessor(sid)));
        });
    }

    @Override
    public Flux<ServiceMessage> requestStream(ServiceMessage request) {
        return Flux.defer(() -> {
            long sid = this.sidCounter.incrementAndGet();
            return this.getOrConnect().flatMapMany(session -> session.send(this.encodeRequest(request, sid), sid).doOnSubscribe(s -> LOGGER.debug("Sending request {}", (Object)request)).thenMany(session.newUnicastProcessor(sid)).doOnCancel(() -> this.handleCancel(sid, (WebsocketSession)session)).doFinally(s -> session.removeProcessor(sid)));
        });
    }

    @Override
    public Flux<ServiceMessage> requestChannel(Flux<ServiceMessage> requests) {
        return Flux.error((Throwable)new UnsupportedOperationException("requestChannel is not supported by WebSocket transport implementation"));
    }

    @Override
    public void close() {
        this.close.onComplete();
    }

    @Override
    public Mono<Void> onClose() {
        return this.onClose;
    }

    private Mono<Void> doClose() {
        return Mono.defer(() -> ((LoopResources)this.loopResources).disposeLater());
    }

    public GatewayClientCodec<ByteBuf> getCodec() {
        return this.codec;
    }

    private Mono<WebsocketSession> getOrConnect() {
        return Mono.defer(() -> websocketMonoUpdater.updateAndGet(this, this::getOrConnect0));
    }

    private Mono<WebsocketSession> getOrConnect0(Mono<WebsocketSession> prev) {
        if (prev != null) {
            return prev;
        }
        Duration keepAliveInterval = this.settings.keepAliveInterval();
        return ((HttpClient.WebsocketSender)this.httpClient.websocket().uri("/")).connect().map(connection -> keepAliveInterval != Duration.ZERO ? connection.onReadIdle(keepAliveInterval.toMillis(), () -> this.onReadIdle((Connection)connection)).onWriteIdle(keepAliveInterval.toMillis(), () -> this.onWriteIdle((Connection)connection)) : connection).map(connection -> {
            WebsocketSession session = new WebsocketSession(this.codec, (Connection)connection);
            LOGGER.info("Created {} on {}:{}", new Object[]{session, this.settings.host(), this.settings.port()});
            session.onClose().doOnTerminate(() -> {
                websocketMonoUpdater.getAndSet(this, null);
                LOGGER.info("Closed {} on {}:{}", new Object[]{session, this.settings.host(), this.settings.port()});
            }).subscribe(null, th -> LOGGER.warn("Exception on closing session={}, cause: {}", (Object)session.id(), (Object)th.toString()));
            return session;
        }).doOnError(ex -> {
            LOGGER.warn("Failed to connect on {}:{}, cause: {}", new Object[]{this.settings.host(), this.settings.port(), ex});
            websocketMonoUpdater.getAndSet(this, null);
        }).cache();
    }

    private void onWriteIdle(Connection connection) {
        LOGGER.debug("Sending keepalive on writeIdle");
        connection.outbound().sendObject((Object)new PingWebSocketFrame()).then().subscribe(null, ex -> LOGGER.warn("Can't send keepalive on writeIdle: " + ex));
    }

    private void onReadIdle(Connection connection) {
        LOGGER.debug("Sending keepalive on readIdle");
        connection.outbound().sendObject((Object)new PingWebSocketFrame()).then().subscribe(null, ex -> LOGGER.warn("Can't send keepalive on readIdle: " + ex));
    }

    private void handleCancel(long sid, WebsocketSession session) {
        ByteBuf byteBuf = this.codec.encode(ServiceMessage.builder().header(STREAM_ID, (Object)sid).header(SIGNAL, Signal.CANCEL.codeAsString()).build());
        session.send(byteBuf, sid).subscribe(null, th -> LOGGER.error("Exception on sending CANCEL signal for session={}", (Object)session.id(), th));
    }

    private ByteBuf encodeRequest(ServiceMessage message, long sid) {
        return this.codec.encode(ServiceMessage.from((ServiceMessage)message).header(STREAM_ID, (Object)sid).build());
    }
}

