/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway.transport.websocket;

public enum Signal {
    COMPLETE(1),
    ERROR(2),
    CANCEL(3);

    private final int code;

    private Signal(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return String.valueOf(this.code);
    }

    public static Signal from(String code) {
        return Signal.from(Integer.parseInt(code));
    }

    public static Signal from(int code) {
        switch (code) {
            case 1: {
                return COMPLETE;
            }
            case 2: {
                return ERROR;
            }
            case 3: {
                return CANCEL;
            }
        }
        throw new IllegalArgumentException("Unknown signal: " + code);
    }
}

