/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway.transport;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.gateway.transport.GatewayClient;
import io.scalecube.services.transport.api.ClientChannel;
import io.scalecube.services.transport.api.ServiceMessageCodec;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GatewayClientChannel
implements ClientChannel {
    private final GatewayClient gatewayClient;

    GatewayClientChannel(GatewayClient gatewayClient) {
        this.gatewayClient = gatewayClient;
    }

    public Mono<ServiceMessage> requestResponse(ServiceMessage clientMessage, Type responseType) {
        return this.gatewayClient.requestResponse(clientMessage).map(msg -> ServiceMessageCodec.decodeData((ServiceMessage)msg, (Type)responseType));
    }

    public Flux<ServiceMessage> requestStream(ServiceMessage clientMessage, Type responseType) {
        return this.gatewayClient.requestStream(clientMessage).map(msg -> ServiceMessageCodec.decodeData((ServiceMessage)msg, (Type)responseType));
    }

    public Flux<ServiceMessage> requestChannel(Publisher<ServiceMessage> clientMessageStream, Type responseType) {
        return this.gatewayClient.requestChannel((Flux<ServiceMessage>)Flux.from(clientMessageStream)).map(msg -> ServiceMessageCodec.decodeData((ServiceMessage)msg, (Type)responseType));
    }
}

