/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.ReferenceCountUtil;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.codec.DataCodec;
import io.scalecube.services.exceptions.BadRequestException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public final class ServiceMessageDataCodec {
    private static final String DEFAULT_DATA_FORMAT = "application/json";
    private static final String ERROR_DATA_ENCODE_FAILED = "Failed to serialize data on %s, cause: %s";
    private static final String ERROR_DATA_DECODE_FAILED = "Failed to deserialize data on %s, cause: %s";

    public ServiceMessage encode(ServiceMessage message) {
        if (message.data() != null) {
            ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                String contentType = Optional.ofNullable(message.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
                DataCodec dataCodec = DataCodec.getInstance(contentType);
                dataCodec.encode((OutputStream)new ByteBufOutputStream(buffer), message.data());
                return ServiceMessage.from((ServiceMessage)message).data((Object)buffer).build();
            }
            catch (Throwable ex) {
                ReferenceCountUtil.release((Object)buffer);
                throw new BadRequestException(String.format(ERROR_DATA_ENCODE_FAILED, message, ex));
            }
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceMessage decode(ServiceMessage message, Class type) {
        if (!(message.data() instanceof ByteBuf)) return message;
        try (ByteBufInputStream inputStream = new ByteBufInputStream((ByteBuf)message.data(), true);){
            String contentType = Optional.ofNullable(message.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
            DataCodec dataCodec = DataCodec.getInstance(contentType);
            ServiceMessage serviceMessage = ServiceMessage.from((ServiceMessage)message).data(dataCodec.decode((InputStream)inputStream, type)).build();
            return serviceMessage;
        }
        catch (Throwable ex) {
            throw new BadRequestException(String.format(ERROR_DATA_DECODE_FAILED, message, ex));
        }
    }
}

