/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.tokens.store;

import io.scalecube.account.api.AddOrganizationApiKeyRequest;
import io.scalecube.account.api.ApiKey;
import io.scalecube.account.api.Role;
import io.scalecube.config.LongConfigProperty;
import io.scalecube.organization.config.AppConfiguration;
import io.scalecube.organization.tokens.JwtApiKey;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

public final class ApiKeyBuilder {
    private static final String ROLE_KEY = "role";
    private static final String ISSUER = "scalecube.io";
    private static final LongConfigProperty tokenExpiration = AppConfiguration.configRegistry().longProperty("token.expiration");

    public static ApiKey build(PrivateKey signingKey, String orgId, String keyId, AddOrganizationApiKeyRequest request) {
        HashMap<String, String> tokenClaims;
        Map<String, String> map = tokenClaims = request.claims() == null || request.claims().isEmpty() ? new HashMap<String, String>() : request.claims();
        if (!tokenClaims.containsKey(ROLE_KEY) || !ApiKeyBuilder.isRoleValid((String)tokenClaims.get(ROLE_KEY))) {
            tokenClaims.put(ROLE_KEY, Role.Member.toString());
        }
        return JwtApiKey.builder().issuer(ISSUER).subject(orgId).name(request.apiKeyName()).claims(tokenClaims).id(orgId).audience(orgId).expiration(tokenExpiration.value().orElse(null)).keyId(keyId).signingKey(signingKey).build();
    }

    private static boolean isRoleValid(String role) {
        try {
            Enum.valueOf(Role.class, role);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }
}

