/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.repository.couchbase;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.scalecube.organization.repository.couchbase.TranslationService;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

class JacksonTranslationService
implements TranslationService {
    private final ObjectMapper objectMapper = new ObjectMapper();

    JacksonTranslationService() {
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    public <T> String encode(T source) {
        StringWriter writer = new StringWriter();
        try {
            this.objectMapper.writeValue((Writer)writer, source);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not encode JSON", ex);
        }
        return ((Object)writer).toString();
    }

    @Override
    public <T> T decode(String source, Class<T> target) {
        try {
            return (T)this.objectMapper.readValue(source, target);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not decode JSON", ex);
        }
    }
}

