/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.operation;

import io.scalecube.account.api.Role;
import io.scalecube.account.api.Token;
import io.scalecube.account.api.UpdateOrganizationMemberRoleRequest;
import io.scalecube.account.api.UpdateOrganizationMemberRoleResponse;
import io.scalecube.organization.domain.Organization;
import io.scalecube.organization.operation.OperationServiceContext;
import io.scalecube.organization.operation.ServiceOperation;
import io.scalecube.organization.repository.OrganizationsRepository;
import io.scalecube.organization.repository.exception.AccessPermissionException;
import io.scalecube.organization.repository.exception.EntityNotFoundException;
import io.scalecube.organization.tokens.TokenVerifier;
import io.scalecube.security.api.Profile;
import reactor.core.publisher.Mono;

public class UpdateOrganizationMemberRole
extends ServiceOperation<UpdateOrganizationMemberRoleRequest, UpdateOrganizationMemberRoleResponse> {
    private UpdateOrganizationMemberRole(TokenVerifier tokenVerifier, OrganizationsRepository repository) {
        super(tokenVerifier, repository);
    }

    @Override
    protected Token getToken(UpdateOrganizationMemberRoleRequest request) {
        return request.token();
    }

    @Override
    protected Mono<UpdateOrganizationMemberRoleResponse> process(UpdateOrganizationMemberRoleRequest request, OperationServiceContext context) {
        return this.getOrganization(request.organizationId()).doOnNext(organization -> organization.updateMemberRole(request.userId(), Role.valueOf((String)request.role()))).flatMap(organization -> context.repository().save(organization.id(), organization)).map(organization -> new UpdateOrganizationMemberRoleResponse());
    }

    @Override
    protected Mono<Void> validate(UpdateOrganizationMemberRoleRequest request, OperationServiceContext context) {
        return Mono.fromRunnable(() -> {
            UpdateOrganizationMemberRole.requireNonNullOrEmpty(request.userId(), "user id is a required argument");
            UpdateOrganizationMemberRole.requireNonNullOrEmpty(request.role(), "role is a required argument");
            UpdateOrganizationMemberRole.requireNonNullOrEmpty(request.organizationId(), "organizationId is a required argument");
        }).then(this.getOrganization(request.organizationId())).doOnNext(organization -> {
            Profile caller = context.profile();
            Role callerRole = this.getRole(context.profile().userId(), (Organization)organization);
            this.checkIsMember(request.userId(), (Organization)organization);
            this.checkSuperUserAccess((Organization)organization, caller);
            this.checkIfRequestToUpdateUserRoleIsValidForCaller(this.toRole(request.role()), context.profile(), callerRole);
            this.checkIfAdminCallerIsTryingToDowngradeAnOwner(caller, callerRole, (Organization)organization, request);
            this.checkLastOwner(request.userId(), (Organization)organization);
        }).then();
    }

    private void checkIfRequestToUpdateUserRoleIsValidForCaller(Role targetRole, Profile profile, Role callerRole) throws AccessPermissionException {
        if (targetRole.isHigherThan(callerRole)) {
            throw new AccessPermissionException(String.format("user: '%s', name: '%s', role: '%s', cannot promote to a higher role: '%s'", profile.userId(), profile.name(), callerRole.toString(), targetRole.toString()));
        }
    }

    private void checkIfAdminCallerIsTryingToDowngradeAnOwner(Profile caller, Role callerRole, Organization organization, UpdateOrganizationMemberRoleRequest request) throws AccessPermissionException, EntityNotFoundException {
        Role updateUserCurrentRole = this.getRole(request.userId(), organization);
        if (updateUserCurrentRole.isHigherThan(callerRole)) {
            throw new AccessPermissionException(String.format("user: '%s', name: '%s', role: %s, cannot downgrade user id: %s, in higher role: '%s'.", caller.userId(), caller.name(), callerRole.toString(), request.userId(), updateUserCurrentRole.toString()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TokenVerifier tokenVerifier;
        private OrganizationsRepository repository;

        public Builder tokenVerifier(TokenVerifier tokenVerifier) {
            this.tokenVerifier = tokenVerifier;
            return this;
        }

        public Builder repository(OrganizationsRepository repository) {
            this.repository = repository;
            return this;
        }

        public UpdateOrganizationMemberRole build() {
            return new UpdateOrganizationMemberRole(this.tokenVerifier, this.repository);
        }
    }
}

