/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class WebToken {
    private final String issuer;
    private final String subject;

    public WebToken(String issuer, String subject) {
        this.issuer = issuer;
        this.subject = subject;
    }

    public String createToken(String id, String audience, Long ttlMillis, String keyId, Key signingKey, Map<String, String> claims) {
        return this.createWebToken(id, this.issuer, this.subject, audience, ttlMillis, keyId, signingKey, claims == null ? new HashMap() : claims);
    }

    private String createWebToken(String id, String issuer, String subject, String audience, Long ttlMillis, String keyId, Key signingKey, Map<String, String> claims) {
        long expMillis;
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        JwtBuilder builder = Jwts.builder().setId(id).setHeaderParam("kid", (Object)keyId).setIssuedAt(now).setSubject(subject).setIssuer(issuer).setAudience(audience).signWith(signatureAlgorithm, signingKey);
        for (Map.Entry<String, String> entry : claims.entrySet()) {
            builder.claim(entry.getKey(), (Object)entry.getValue());
        }
        if (ttlMillis != null && ttlMillis >= 0L && (expMillis = nowMillis + ttlMillis) > 0L) {
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public boolean isValidToken(String token, String id, String secretKey) {
        Claims claims = this.parseWebToken(token, secretKey);
        if (claims != null && claims.getId().equals(id) && claims.getSubject().equals(this.subject) && claims.getIssuer().equals(this.issuer)) {
            long nowMillis = System.currentTimeMillis();
            Date now = new Date(nowMillis);
            if (claims.getExpiration() != null && claims.getExpiration().after(now)) {
                return true;
            }
        }
        return false;
    }

    private Claims parseWebToken(String jwt, String secretKey) {
        Claims claims = null;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secretKey)).parseClaimsJws(jwt).getBody();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return claims;
    }

    public Claims parse(String token, String secretKey) {
        return this.parseWebToken(token, secretKey);
    }
}

