/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.config;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.Slf4JConfigEventListener;
import io.scalecube.config.source.ClassPathConfigSource;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.SystemEnvironmentConfigSource;
import io.scalecube.config.source.SystemPropertiesConfigSource;
import io.scalecube.config.vault.VaultConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class AppConfiguration {
    private static final int RELOAD_INTERVAL_SEC = 300;
    private static final Pattern CONFIG_PATTERN = Pattern.compile("(.*)\\.config\\.properties");
    private static final Predicate<Path> PATH_PREDICATE = path -> CONFIG_PATTERN.matcher(path.toString()).matches();
    private static final ConfigRegistry configRegistry;

    public static ConfigRegistry configRegistry() {
        return configRegistry;
    }

    static {
        ConfigRegistrySettings.Builder builder = ConfigRegistrySettings.builder().reloadIntervalSec(300).addListener((ConfigEventListener)new Slf4JConfigEventListener());
        if (System.getenv().get("VAULT_ADDR") != null) {
            builder.addLastSource("vault", (ConfigSource)VaultConfigSource.builder().build());
        }
        builder.addLastSource("sys_prop", (ConfigSource)new SystemPropertiesConfigSource());
        builder.addLastSource("env_var", (ConfigSource)new SystemEnvironmentConfigSource());
        builder.addLastSource("cp", (ConfigSource)new ClassPathConfigSource(new Predicate[]{PATH_PREDICATE}));
        configRegistry = ConfigRegistry.create((ConfigRegistrySettings)builder.build());
    }
}

