/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.scalecube.metrics.Key;
import io.scalecube.metrics.KeyCodec;
import io.scalecube.metrics.MetricNames;
import io.scalecube.metrics.MetricsHandler;
import io.scalecube.metrics.mimir.MimirPublisher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.Histogram;
import org.agrona.DirectBuffer;
import prometheus.Remote;
import prometheus.Types;

public class MetricsMimirHandler
implements MetricsHandler {
    private static final double[] PERCENTILES = new double[]{10.0, 50.0, 90.0, 95.0, 99.0, 99.5, 99.9, 99.99, 99.999};
    private final Map<String, String> tags;
    private final MimirPublisher.WriteProxy writeProxy;
    private final KeyCodec keyCodec = new KeyCodec();

    public MetricsMimirHandler(Map<String, String> tags, MimirPublisher.WriteProxy writeProxy) {
        this.tags = tags;
        this.writeProxy = writeProxy;
    }

    public void onHistogram(long timestamp, DirectBuffer keyBuffer, int keyOffset, int keyLength, Histogram accumulated, Histogram distinct, long highestTrackableValue, double conversionFactor) {
        Key key = this.keyCodec.decodeKey(keyBuffer, keyOffset);
        String name = key.stringValue("name");
        Map<String, String> tags = this.toTags(key);
        if (name != null) {
            this.writeProxy.push(Remote.WriteRequest.newBuilder().addAllTimeseries(MetricsMimirHandler.toTimeSeriesList(timestamp, name, tags, conversionFactor, distinct)).build());
        }
    }

    public void onTps(long timestamp, DirectBuffer keyBuffer, int keyOffset, int keyLength, long value) {
        Key key = this.keyCodec.decodeKey(keyBuffer, keyOffset);
        String name = key.stringValue("name");
        Map<String, String> tags = this.toTags(key);
        if (name != null) {
            this.writeProxy.push(Remote.WriteRequest.newBuilder().addAllTimeseries(MetricsMimirHandler.toTimeSeriesList(timestamp, name, tags, value)).build());
        }
    }

    private Map<String, String> toTags(Key key) {
        HashMap<String, String> allTags = new HashMap<String, String>();
        if (this.tags != null) {
            allTags.putAll(this.tags);
        }
        for (Map.Entry entry : key.tags().entrySet()) {
            String tagId = (String)entry.getKey();
            Object value = entry.getValue();
            allTags.put(tagId, String.valueOf(value));
        }
        return allTags;
    }

    private static List<Types.TimeSeries> toTimeSeriesList(long timestamp, String name, Map<String, String> tags, double conversionFactor, Histogram histogram) {
        ArrayList<Types.TimeSeries> tsList = new ArrayList<Types.TimeSeries>();
        for (double percentile : PERCENTILES) {
            double value = (double)histogram.getValueAtPercentile(percentile) * conversionFactor;
            Types.TimeSeries.Builder percentileBuilder = Types.TimeSeries.newBuilder().addLabels(Types.Label.newBuilder().setName("__name__").setValue(name).build()).addLabels(Types.Label.newBuilder().setName("p").setValue(MetricsMimirHandler.formatPercentile(percentile)).build()).addSamples(Types.Sample.newBuilder().setValue(value).setTimestamp(timestamp).build());
            MetricsMimirHandler.addLabels(percentileBuilder, tags);
            tsList.add(percentileBuilder.build());
        }
        double value = (double)histogram.getMaxValue() * conversionFactor;
        Types.TimeSeries.Builder maxBuilder = Types.TimeSeries.newBuilder().addLabels(Types.Label.newBuilder().setName("__name__").setValue(name).build()).addLabels(Types.Label.newBuilder().setName("p").setValue("max").build()).addSamples(Types.Sample.newBuilder().setValue(value).setTimestamp(timestamp).build());
        MetricsMimirHandler.addLabels(maxBuilder, tags);
        tsList.add(maxBuilder.build());
        Types.TimeSeries.Builder countBuilder = Types.TimeSeries.newBuilder().addLabels(Types.Label.newBuilder().setName("__name__").setValue(name + "_count").build()).addSamples(Types.Sample.newBuilder().setValue(histogram.getTotalCount()).setTimestamp(timestamp).build());
        MetricsMimirHandler.addLabels(countBuilder, tags);
        tsList.add(countBuilder.build());
        return tsList;
    }

    private static List<Types.TimeSeries> toTimeSeriesList(long timestamp, String name, Map<String, String> tags, long value) {
        ArrayList<Types.TimeSeries> tsList = new ArrayList<Types.TimeSeries>();
        Types.TimeSeries.Builder tpsBuilder = Types.TimeSeries.newBuilder().addLabels(Types.Label.newBuilder().setName("__name__").setValue(name).build()).addSamples(Types.Sample.newBuilder().setValue(value).setTimestamp(timestamp).build());
        MetricsMimirHandler.addLabels(tpsBuilder, tags);
        tsList.add(tpsBuilder.build());
        return tsList;
    }

    private static String formatPercentile(double value) {
        if (value == Math.floor(value)) {
            return String.valueOf((int)value);
        }
        return String.valueOf(value);
    }

    private static void addLabels(Types.TimeSeries.Builder builder, Map<String, String> tags) {
        if (tags != null) {
            tags.forEach((name, value) -> {
                if (!"name".equals(name)) {
                    builder.addLabels(Types.Label.newBuilder().setName(MetricNames.sanitizeName((String)name)).setValue(String.valueOf(value)).build());
                }
            });
        }
    }
}

