/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.scalecube.metrics.CounterDescriptor;
import io.scalecube.metrics.CountersHandler;
import io.scalecube.metrics.Key;
import io.scalecube.metrics.KeyCodec;
import io.scalecube.metrics.MetricNames;
import io.scalecube.metrics.mimir.MimirPublisher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import prometheus.Remote;
import prometheus.Types;

public class CountersMimirHandler
implements CountersHandler {
    private final Map<String, String> tags;
    private final MimirPublisher.WriteProxy writeProxy;
    private final KeyCodec keyCodec = new KeyCodec();

    public CountersMimirHandler(Map<String, String> tags, MimirPublisher.WriteProxy writeProxy) {
        this.tags = tags;
        this.writeProxy = writeProxy;
    }

    public void accept(long timestamp, List<CounterDescriptor> counterDescriptors) {
        Remote.WriteRequest.Builder builder = Remote.WriteRequest.newBuilder();
        for (CounterDescriptor descriptor : counterDescriptors) {
            String name;
            Key key = this.keyCodec.decodeKey(descriptor.keyBuffer(), 0);
            String visibility = key.stringValue("visibility");
            if ("private".equals(visibility) || (name = descriptor.label() != null ? descriptor.label() : key.stringValue("name")) == null) continue;
            Map<String, String> tags = this.toTags(key);
            long value = descriptor.value();
            builder.addTimeseries(CountersMimirHandler.toTimeSeries(timestamp, name, tags, value));
        }
        if (builder.getTimeseriesCount() > 0) {
            this.writeProxy.push(builder.build());
        }
    }

    private Map<String, String> toTags(Key key) {
        HashMap<String, String> allTags = new HashMap<String, String>();
        if (this.tags != null) {
            allTags.putAll(this.tags);
        }
        for (Map.Entry entry : key.tags().entrySet()) {
            String tagId = (String)entry.getKey();
            Object value = entry.getValue();
            allTags.put(tagId, String.valueOf(value));
        }
        return allTags;
    }

    private static Types.TimeSeries toTimeSeries(long timestamp, String name, Map<String, String> tags, long value) {
        Types.TimeSeries.Builder builder = Types.TimeSeries.newBuilder().addLabels(Types.Label.newBuilder().setName("__name__").setValue(MetricNames.sanitizeName((String)name)).build()).addSamples(Types.Sample.newBuilder().setValue(value).setTimestamp(timestamp).build());
        CountersMimirHandler.addLabels(builder, tags);
        return builder.build();
    }

    private static void addLabels(Types.TimeSeries.Builder builder, Map<String, String> tags) {
        if (tags != null) {
            tags.forEach((name, value) -> {
                if (!"name".equals(name)) {
                    builder.addLabels(Types.Label.newBuilder().setName(MetricNames.sanitizeName((String)name)).setValue(String.valueOf(value)).build());
                }
            });
        }
    }
}

