/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.scalecube.metrics.HistogramMetric;
import io.scalecube.metrics.MetricsHandler;
import io.scalecube.metrics.MetricsReaderAgent;
import io.scalecube.metrics.MetricsRecorder;
import io.scalecube.metrics.MetricsTransmitter;
import io.scalecube.metrics.mimir.MetricsMimirHandler;
import io.scalecube.metrics.mimir.MimirPublisher;
import java.time.Duration;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.MountableFile;

public class MimirAllInOnePercentiles {
    public static void main(String[] args) {
        Network network = Network.newNetwork();
        GenericContainer mimir = new GenericContainer("grafana/mimir").withExposedPorts(new Integer[]{9009}).withNetwork(network).withNetworkAliases(new String[]{"mimir"}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"mimir.yml"), "/etc/mimir.yml").withCommand(new String[]{"-config.file=/etc/mimir.yml", "-target=all", "-log.level=debug"}).withLogConsumer(outputFrame -> System.err.print("[mimir] " + outputFrame.getUtf8String()));
        mimir.start();
        GenericContainer grafana = new GenericContainer("grafana/grafana").withExposedPorts(new Integer[]{3000}).withNetwork(network).withNetworkAliases(new String[]{"grafana"}).withEnv("GF_SECURITY_ADMIN_USER", "user").withEnv("GF_SECURITY_ADMIN_PASSWORD", "password").withCopyFileToContainer(MountableFile.forClasspathResource((String)"mimir.datasource.yml"), "/etc/grafana/provisioning/datasources/datasource.yml");
        grafana.start();
        Integer mimirPort = mimir.getMappedPort(9009);
        String pushUrl = "http://" + mimir.getHost() + ":" + mimirPort + "/api/v1/push";
        String grafanaUrl = "http://" + grafana.getHost() + ":" + grafana.getMappedPort(3000);
        System.out.println("Started Mimir on: " + mimirPort + " | pushUrl: " + pushUrl);
        System.out.println("Grafana is available at: " + grafanaUrl);
        MetricsRecorder metricsRecorder = MetricsRecorder.launch();
        MetricsTransmitter metricsTransmitter = MetricsTransmitter.launch();
        MimirPublisher mimirPublisher = MimirPublisher.launch((MimirPublisher.Context)new MimirPublisher.Context().url(pushUrl));
        AgentRunner.startOnThread((AgentRunner)new AgentRunner((IdleStrategy)new BackoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)new MetricsReaderAgent("MetricsReaderAgent", metricsTransmitter.context().broadcastBuffer(), (EpochClock)SystemEpochClock.INSTANCE, Duration.ofSeconds(3L), (MetricsHandler)new MetricsMimirHandler(null, mimirPublisher.proxy()))));
        long highestTrackableValue = 1000000000L;
        double conversionFactor = 0.001;
        int resolutionMs = 10000;
        HistogramMetric latencyMetric = metricsRecorder.newHistogram(keyFlyweight -> keyFlyweight.tagsCount(1).stringValue("name", "hft_latency"), 1000000000L, 0.001, 10000L);
        while (true) {
            long now = System.nanoTime();
            MimirAllInOnePercentiles.burnCpuMicros(20L);
            latencyMetric.record(System.nanoTime() - now);
            Thread.onSpinWait();
        }
    }

    private static void burnCpuMicros(long micros) {
        long durationNanos = micros * 1000L;
        long start = System.nanoTime();
        while (System.nanoTime() - start < durationNanos) {
            Thread.onSpinWait();
        }
    }
}

