/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.loki;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.scalecube.metrics.Delay;
import io.scalecube.metrics.loki.WriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPOutputStream;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LokiPublisherAgent
implements Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(LokiPublisherAgent.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private final String url;
    private final int writeLimit;
    private final ManyToOneConcurrentArrayQueue<WriteRequest> writeQueue;
    private final Delay retryInterval;
    private final Delay publishInterval;
    private HttpClient httpClient;
    private ExecutorService executor;
    private CompletableFuture<HttpResponse<String>> future;
    private State state = State.CLOSED;

    public LokiPublisherAgent(String url, EpochClock epochClock, Duration retryInterval, Duration publishInterval, int writeLimit, ManyToOneConcurrentArrayQueue<WriteRequest> writeQueue) {
        this.url = url;
        this.writeLimit = writeLimit;
        this.writeQueue = writeQueue;
        this.retryInterval = new Delay(epochClock, retryInterval.toMillis());
        this.publishInterval = new Delay(epochClock, publishInterval.toMillis());
    }

    public String roleName() {
        return "LokiPublisherAgent";
    }

    public void onStart() {
        if (this.state != State.CLOSED) {
            throw new AgentTerminationException("Illegal state: " + String.valueOf((Object)this.state));
        }
        this.state(State.INIT);
    }

    public int doWork() throws Exception {
        try {
            return switch (this.state) {
                case State.INIT -> this.init();
                case State.RUNNING -> this.running();
                case State.CLEANUP -> this.cleanup();
                default -> throw new AgentTerminationException("Unknown state: " + String.valueOf((Object)this.state));
            };
        }
        catch (AgentTerminationException e) {
            throw e;
        }
        catch (Exception e) {
            this.state(State.CLEANUP);
            throw e;
        }
    }

    private int init() {
        if (this.retryInterval.isNotOverdue()) {
            return 0;
        }
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.httpClient = HttpClient.newBuilder().executor(this.executor).build();
        this.publishInterval.delay();
        this.state(State.RUNNING);
        return 1;
    }

    private int running() throws Exception {
        if (this.publishInterval.isOverdue()) {
            this.publishInterval.delay();
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            ArrayList<WriteRequest.Stream> streams = new ArrayList<WriteRequest.Stream>();
            this.writeQueue.drain(request -> streams.addAll(request.streams()), this.writeLimit);
            if (!streams.isEmpty()) {
                this.future = this.send(new WriteRequest(streams));
            }
        }
        if (this.future != null && this.future.isDone()) {
            HttpResponse<String> response = this.future.get();
            int statusCode = response.statusCode();
            if (statusCode != 200 && statusCode != 204) {
                LOGGER.warn("Failed to push metrics: HTTP {}, body: {}", (Object)statusCode, (Object)response.body());
            }
            this.future = null;
            return 1;
        }
        return 0;
    }

    private CompletableFuture<HttpResponse<String>> send(WriteRequest request) {
        return this.httpClient.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.url)).header("Content-Type", "application/json").header("Content-Encoding", "gzip").POST(HttpRequest.BodyPublishers.ofByteArray(LokiPublisherAgent.gzip(request))).build(), HttpResponse.BodyHandlers.ofString());
    }

    public static byte[] gzip(WriteRequest request) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (GZIPOutputStream outputStream = new GZIPOutputStream(byteStream);){
            OBJECT_MAPPER.writeValue((OutputStream)outputStream, (Object)request);
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        return byteStream.toByteArray();
    }

    private int cleanup() {
        State previous;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.httpClient = null;
        this.executor = null;
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if ((previous = this.state) != State.CLOSED) {
            this.retryInterval.delay();
            this.state(State.INIT);
        }
        return 1;
    }

    public void onClose() {
        this.state(State.CLOSED);
        this.cleanup();
    }

    private void state(State state) {
        LOGGER.debug("[{}][state] {}->{}", new Object[]{this.roleName(), this.state, state});
        this.state = state;
    }

    public static enum State {
        INIT,
        RUNNING,
        CLEANUP,
        CLOSED;

    }
}

