/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.archive.Archive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.client.EgressListener;
import io.aeron.cluster.codecs.AdminRequestType;
import io.aeron.cluster.codecs.AdminResponseCode;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.Cluster;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.driver.MediaDriver;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.Header;
import io.scalecube.metrics.CountersHandler;
import io.scalecube.metrics.CountersReaderAgent;
import io.scalecube.metrics.CountersRegistry;
import io.scalecube.metrics.HistogramMetric;
import io.scalecube.metrics.MetricsHandler;
import io.scalecube.metrics.MetricsReaderAgent;
import io.scalecube.metrics.MetricsRecorder;
import io.scalecube.metrics.MetricsTransmitter;
import io.scalecube.metrics.TpsMetric;
import io.scalecube.metrics.aeron.CncCountersReaderAgent;
import io.scalecube.metrics.mimir.CountersMimirHandler;
import io.scalecube.metrics.mimir.MetricsMimirHandler;
import io.scalecube.metrics.mimir.MimirPublisher;
import java.time.Duration;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.MountableFile;

public class MimirAllInOneAeron {
    public static void main(String[] args) throws Exception {
        Network network = Network.newNetwork();
        GenericContainer mimir = new GenericContainer("grafana/mimir").withExposedPorts(new Integer[]{9009}).withNetwork(network).withNetworkAliases(new String[]{"mimir"}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"mimir.yml"), "/etc/mimir.yml").withCommand(new String[]{"-config.file=/etc/mimir.yml", "-target=all", "-log.level=debug"}).withLogConsumer(outputFrame -> System.err.print("[mimir] " + outputFrame.getUtf8String()));
        mimir.start();
        GenericContainer grafana = new GenericContainer("grafana/grafana").withExposedPorts(new Integer[]{3000}).withNetwork(network).withNetworkAliases(new String[]{"grafana"}).withEnv("GF_SECURITY_ADMIN_USER", "user").withEnv("GF_SECURITY_ADMIN_PASSWORD", "password").withCopyFileToContainer(MountableFile.forClasspathResource((String)"mimir.datasource.yml"), "/etc/grafana/provisioning/datasources/datasource.yml");
        grafana.start();
        Integer mimirPort = mimir.getMappedPort(9009);
        String pushUrl = "http://" + mimir.getHost() + ":" + mimirPort + "/api/v1/push";
        String grafanaUrl = "http://" + grafana.getHost() + ":" + grafana.getMappedPort(3000);
        System.out.println("Started Mimir on: " + mimirPort + " | pushUrl: " + pushUrl);
        System.out.println("Grafana is available at: " + grafanaUrl);
        MetricsRecorder metricsRecorder = MetricsRecorder.launch();
        MetricsTransmitter metricsTransmitter = MetricsTransmitter.launch();
        CountersRegistry countersRegistry = CountersRegistry.create();
        CountersManager countersManager = countersRegistry.countersManager();
        AtomicCounter sessionCounter = countersManager.newCounter("session_count");
        MediaDriver mediaDriver = MediaDriver.launch((MediaDriver.Context)new MediaDriver.Context().dirDeleteOnStart(true).dirDeleteOnShutdown(true));
        Aeron aeron = Aeron.connect();
        Archive archive = Archive.launch((Archive.Context)new Archive.Context().recordingEventsEnabled(false).archiveDirectoryName("target/aeron-archive").controlChannel("aeron:udp?endpoint=localhost:8010").replicationChannel("aeron:udp?endpoint=localhost:0"));
        ConsensusModule consensusModule = ConsensusModule.launch((ConsensusModule.Context)new ConsensusModule.Context().ingressChannel("aeron:udp").replicationChannel("aeron:udp?endpoint=localhost:0").clusterDirectoryName("target/aeron-cluster").clusterMemberId(0).clusterMembers("0,localhost:8005,localhost:8006,localhost:8007,localhost:8008,localhost:8010"));
        ClusteredServiceContainer serviceContainer = ClusteredServiceContainer.launch((ClusteredServiceContainer.Context)new ClusteredServiceContainer.Context().clusterDirectoryName("target/aeron-cluster").clusteredService((ClusteredService)new ClusteredServiceImpl(metricsRecorder, sessionCounter)));
        final AeronCluster aeronCluster = AeronCluster.connect((AeronCluster.Context)new AeronCluster.Context().ingressChannel("aeron:udp").ingressEndpoints("0=localhost:8005").isIngressExclusive(true).egressChannel("aeron:udp?endpoint=localhost:0").egressListener((EgressListener)new EgressListenerImpl(metricsRecorder)));
        System.out.println("Started mediaDriver: " + String.valueOf(mediaDriver));
        System.out.println("Started aeron: " + String.valueOf(aeron));
        System.out.println("Started archive: " + String.valueOf(archive));
        System.out.println("Started consensusModule: " + String.valueOf(consensusModule));
        System.out.println("Started serviceContainer: " + String.valueOf(serviceContainer));
        System.out.println("Connected aeronCluster: " + String.valueOf(aeronCluster));
        MimirPublisher mimirPublisher = MimirPublisher.launch((MimirPublisher.Context)new MimirPublisher.Context().url(pushUrl));
        CompositeAgent compositeAgent = new CompositeAgent(new Agent[]{new CountersReaderAgent("CountersReaderAgent", countersRegistry.context().countersDir(), true, (EpochClock)SystemEpochClock.INSTANCE, Duration.ofSeconds(1L), (CountersHandler)new CountersMimirHandler(null, mimirPublisher.proxy())), new CncCountersReaderAgent("CncCountersReaderAgent", mediaDriver.aeronDirectoryName(), true, (EpochClock)SystemEpochClock.INSTANCE, Duration.ofSeconds(3L), Duration.ofSeconds(5L), (CountersHandler)new CountersMimirHandler(null, mimirPublisher.proxy())), new MetricsReaderAgent("MetricsReaderAgent", metricsTransmitter.context().broadcastBuffer(), (EpochClock)SystemEpochClock.INSTANCE, Duration.ofSeconds(3L), (MetricsHandler)new MetricsMimirHandler(null, mimirPublisher.proxy()))});
        AgentRunner.startOnThread((AgentRunner)new AgentRunner((IdleStrategy)new BackoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)compositeAgent));
        AgentRunner.startOnThread((AgentRunner)new AgentRunner((IdleStrategy)new BackoffIdleStrategy(), Throwable::printStackTrace, null, new Agent(){

            public int doWork() {
                return aeronCluster.pollEgress();
            }

            public String roleName() {
                return "";
            }
        }));
        BufferClaim bufferClaim = new BufferClaim();
        while (true) {
            long claim;
            if ((claim = aeronCluster.tryClaim(8, bufferClaim)) == -4L || claim == -5L || Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("Good bye");
            }
            if (claim > 0L) {
                MutableDirectBuffer buffer = bufferClaim.buffer();
                int offset = bufferClaim.offset();
                int i = offset + 32;
                long now = System.nanoTime();
                buffer.putLong(i, now);
                bufferClaim.commit();
            }
            Thread.sleep(1L);
        }
    }

    private static class ClusteredServiceImpl
    implements ClusteredService {
        private static final long HIGHEST_TRACKABLE_VALUE = 1000000000L;
        private static final double CONVERSION_FACTOR = 0.001;
        private static final long RESOLUTION_MS = 3000L;
        private static final int LENGTH = 16;
        private final MetricsRecorder metricsRecorder;
        private final AtomicCounter sessionCounter;
        private final BufferClaim bufferClaim = new BufferClaim();
        private TpsMetric tpsMetric;
        private HistogramMetric pingMetric;

        private ClusteredServiceImpl(MetricsRecorder metricsRecorder, AtomicCounter sessionCounter) {
            this.metricsRecorder = metricsRecorder;
            this.sessionCounter = sessionCounter;
        }

        public void onStart(Cluster cluster, Image snapshotImage) {
            this.tpsMetric = this.metricsRecorder.newTps(keyFlyweight -> keyFlyweight.tagsCount(1).stringValue("name", "tps"));
            this.pingMetric = this.metricsRecorder.newHistogram(keyFlyweight -> keyFlyweight.tagsCount(2).stringValue("name", "hft_latency").stringValue("kind", "ping"), 1000000000L, 0.001, 3000L);
        }

        public void onSessionOpen(ClientSession session, long timestamp) {
            System.out.println("onSessionOpen: " + String.valueOf(session));
            this.sessionCounter.increment();
        }

        public void onSessionClose(ClientSession session, long timestamp, CloseReason closeReason) {
            System.out.println("onSessionClose: " + String.valueOf(session) + ", closeReason=" + String.valueOf(closeReason));
            this.sessionCounter.decrement();
        }

        public void onSessionMessage(ClientSession session, long timestamp, DirectBuffer buffer, int offset, int length, Header header) {
            this.tpsMetric.record();
            long ping = buffer.getLong(offset);
            long pong = System.nanoTime();
            long delta = pong - ping;
            this.pingMetric.record(delta);
            if (session.tryClaim(16, this.bufferClaim) > 0L) {
                MutableDirectBuffer buf = this.bufferClaim.buffer();
                int index = this.bufferClaim.offset() + 32;
                buf.putLong(index, ping);
                buf.putLong(index + 8, pong);
                this.bufferClaim.commit();
            }
        }

        public void onTimerEvent(long correlationId, long timestamp) {
        }

        public void onTakeSnapshot(ExclusivePublication snapshotPublication) {
        }

        public void onRoleChange(Cluster.Role newRole) {
        }

        public void onTerminate(Cluster cluster) {
        }
    }

    private static class EgressListenerImpl
    implements EgressListener {
        private static final long HIGHEST_TRACKABLE_VALUE = 1000000000L;
        private static final double CONVERSION_FACTOR = 0.001;
        private static final long RESOLUTION_MS = 3000L;
        private final HistogramMetric pongMetric;
        private final HistogramMetric rttMetric;

        private EgressListenerImpl(MetricsRecorder metricsRecorder) {
            this.pongMetric = metricsRecorder.newHistogram(keyFlyweight -> keyFlyweight.tagsCount(2).stringValue("name", "hft_latency").stringValue("kind", "pong"), 1000000000L, 0.001, 3000L);
            this.rttMetric = metricsRecorder.newHistogram(keyFlyweight -> keyFlyweight.tagsCount(2).stringValue("name", "hft_latency").stringValue("kind", "rtt"), 1000000000L, 0.001, 3000L);
        }

        public void onMessage(long clusterSessionId, long timestamp, DirectBuffer buffer, int offset, int length, Header header) {
            long now = System.nanoTime();
            long ping = buffer.getLong(offset);
            long pong = buffer.getLong(offset + 8);
            this.pongMetric.record(now - pong);
            this.rttMetric.record(now - ping);
        }

        public void onSessionEvent(long correlationId, long clusterSessionId, long leadershipTermId, int leaderMemberId, EventCode code, String detail) {
            System.out.println("onSessionEvent: clusterSessionId=" + clusterSessionId + ", leadershipTermId=" + leadershipTermId + ", leaderMemberId=" + leaderMemberId + ", code=" + String.valueOf(code) + ", detail=" + detail);
        }

        public void onNewLeader(long clusterSessionId, long leadershipTermId, int leaderMemberId, String ingressEndpoints) {
            System.out.println("onNewLeader: leadershipTermId=" + leadershipTermId + ", leaderMemberId=" + leaderMemberId);
        }

        public void onAdminResponse(long clusterSessionId, long correlationId, AdminRequestType requestType, AdminResponseCode responseCode, String message, DirectBuffer payload, int payloadOffset, int payloadLength) {
            System.out.println("onAdminResponse: requestType=" + String.valueOf(requestType) + ", responseCode=" + String.valueOf(responseCode));
        }
    }
}

