/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.scalecube.metrics.HistogramMetric;
import io.scalecube.metrics.MetricsHandler;
import io.scalecube.metrics.MetricsReaderAgent;
import io.scalecube.metrics.MetricsRecorder;
import io.scalecube.metrics.MetricsTransmitter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.MountableFile;

public class PrometheusNativeHistogram {
    public static void main(String[] args) throws IOException {
        Network network = Network.newNetwork();
        GenericContainer prometheus = new GenericContainer("prom/prometheus").withNetwork(network).withNetworkAliases(new String[]{"prometheus"}).withExposedPorts(new Integer[]{9090}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"prometheus.yml"), "/etc/prometheus/prometheus.yml").withCommand(new String[]{"--config.file=/etc/prometheus/prometheus.yml", "--enable-feature=native-histograms", "--log.level=debug"});
        prometheus.start();
        GenericContainer grafana = new GenericContainer("grafana/grafana").withNetwork(network).withExposedPorts(new Integer[]{3000}).withEnv("GF_SECURITY_ADMIN_USER", "user").withEnv("GF_SECURITY_ADMIN_PASSWORD", "password").withCopyFileToContainer(MountableFile.forClasspathResource((String)"prometheus.datasource.yml"), "/etc/grafana/provisioning/datasources/datasource.yml");
        grafana.start();
        String grafanaUrl = "http://" + grafana.getHost() + ":" + grafana.getMappedPort(3000);
        System.out.println("Started prometheus on: " + prometheus.getMappedPort(9090));
        System.out.println("Grafana is available at: " + grafanaUrl);
        InetSocketAddress socketAddress = new InetSocketAddress(8080);
        HttpServer server = HttpServer.create(socketAddress, 0);
        MetricsHandlerAdapter metricsHandlerAdapter = new MetricsHandlerAdapter("hft_latency", "HFT latency");
        server.createContext("/metrics", metricsHandlerAdapter);
        server.setExecutor(null);
        server.start();
        System.out.println(String.valueOf(Instant.now()) + " | Server started on " + String.valueOf(socketAddress));
        MetricsRecorder metricsRecorder = MetricsRecorder.launch();
        MetricsTransmitter metricsTransmitter = MetricsTransmitter.launch();
        AgentRunner.startOnThread((AgentRunner)new AgentRunner((IdleStrategy)new BackoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)new MetricsReaderAgent("MetricsReaderAgent", metricsTransmitter.context().broadcastBuffer(), (EpochClock)SystemEpochClock.INSTANCE, Duration.ofSeconds(3L), (MetricsHandler)metricsHandlerAdapter)));
        long highestTrackableValue = 1000000000L;
        double conversionFactor = 0.001;
        int resolutionMs = 1000;
        HistogramMetric latencyMetric = metricsRecorder.newHistogram(keyFlyweight -> keyFlyweight.tagsCount(1).stringValue("name", "hft_latency"), 1000000000L, 0.001, 1000L);
        while (true) {
            long now = System.nanoTime();
            PrometheusNativeHistogram.burnCpuMicros(20L);
            long delta = System.nanoTime() - now;
            latencyMetric.record(delta);
            Thread.onSpinWait();
        }
    }

    private static void burnCpuMicros(long micros) {
        long durationNanos = micros * 1000L;
        long start = System.nanoTime();
        while (System.nanoTime() - start < durationNanos) {
            Thread.onSpinWait();
        }
    }

    private static class MetricsHandlerAdapter
    implements MetricsHandler,
    HttpHandler {
        private final String metricName;
        private final String help;
        private final AtomicReference<Histogram> latestHistogram = new AtomicReference();

        public MetricsHandlerAdapter(String metricName, String help) {
            this.metricName = metricName;
            this.help = help;
        }

        public void onHistogram(long timestamp, DirectBuffer keyBuffer, int keyOffset, int keyLength, Histogram accumulated, Histogram distinct, long highestTrackableValue, double conversionFactor) {
            Histogram latest = this.latestHistogram.get();
            if (latest != null) {
                latest.add((AbstractHistogram)distinct);
                this.latestHistogram.set(latest);
            } else {
                this.latestHistogram.set(distinct);
            }
        }

        @Override
        public void handle(HttpExchange exchange) {
            try {
                Histogram histogram = this.latestHistogram.getAndSet(null);
                StringBuilder sb = new StringBuilder();
                sb.append("# HELP ").append(this.metricName).append(" ").append(this.help).append("\n");
                sb.append("# TYPE ").append(this.metricName).append(" histogram\n");
                if (histogram != null && histogram.getTotalCount() > 0L) {
                    System.out.println(String.valueOf(Instant.now()) + " | Scrape histogram");
                    long totalCount = histogram.getTotalCount();
                    double totalSum = 0.0;
                    long cumulativeCount = 0L;
                    for (HistogramIterationValue v : histogram.recordedValues()) {
                        long rawValue = v.getValueIteratedTo();
                        long count = v.getCountAtValueIteratedTo();
                        double upperBound = (double)rawValue / 1000.0;
                        totalSum += upperBound * (double)count;
                        sb.append(this.metricName).append("{native=\"true\",scale=\"3\",le=\"").append(MetricsHandlerAdapter.formatDouble(upperBound)).append("\"} ").append(cumulativeCount += count).append("\n");
                    }
                    sb.append(this.metricName).append("{native=\"true\",scale=\"3\",le=\"+Inf\"} ").append(totalCount).append("\n");
                    sb.append(this.metricName).append("_sum ").append(MetricsHandlerAdapter.formatDouble(totalSum)).append("\n");
                    sb.append(this.metricName).append("_count ").append(totalCount).append("\n");
                }
                sb.append("# EOF\n");
                byte[] response = sb.toString().getBytes();
                exchange.getResponseHeaders().set("Content-Type", "application/openmetrics-text; version=1.0.0; charset=utf-8");
                exchange.sendResponseHeaders(200, response.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                try {
                    exchange.sendResponseHeaders(500, -1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static String formatDouble(double upperBound) {
            return String.format("%.3f", upperBound);
        }
    }
}

