/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.scalecube.metrics.HistogramMetric;
import io.scalecube.metrics.Key;
import io.scalecube.metrics.KeyCodec;
import io.scalecube.metrics.MetricsHandler;
import io.scalecube.metrics.MetricsReaderAgent;
import io.scalecube.metrics.MetricsRecorder;
import io.scalecube.metrics.MetricsTransmitter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.MountableFile;
import org.xerial.snappy.Snappy;
import prometheus.Remote;
import prometheus.Types;

public class MimirAllInOneHistogram {
    public static void main(String[] args) {
        Network network = Network.newNetwork();
        GenericContainer mimir = new GenericContainer("grafana/mimir").withExposedPorts(new Integer[]{9009}).withNetwork(network).withNetworkAliases(new String[]{"mimir"}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"mimir.yml"), "/etc/mimir.yml").withCommand(new String[]{"-config.file=/etc/mimir.yml", "-target=all", "-log.level=debug"}).withLogConsumer(outputFrame -> System.err.print("[mimir] " + outputFrame.getUtf8String()));
        mimir.start();
        GenericContainer grafana = new GenericContainer("grafana/grafana").withExposedPorts(new Integer[]{3000}).withNetwork(network).withNetworkAliases(new String[]{"grafana"}).withEnv("GF_SECURITY_ADMIN_USER", "user").withEnv("GF_SECURITY_ADMIN_PASSWORD", "password").withCopyFileToContainer(MountableFile.forClasspathResource((String)"mimir.datasource.yml"), "/etc/grafana/provisioning/datasources/datasource.yml");
        grafana.start();
        Integer mimirPort = mimir.getMappedPort(9009);
        String pushUrl = "http://" + mimir.getHost() + ":" + mimirPort + "/api/v1/push";
        String grafanaUrl = "http://" + grafana.getHost() + ":" + grafana.getMappedPort(3000);
        System.out.println("Started Mimir on: " + mimirPort + " | pushUrl: " + pushUrl);
        System.out.println("Grafana is available at: " + grafanaUrl);
        MetricsRecorder metricsRecorder = MetricsRecorder.launch();
        MetricsTransmitter metricsTransmitter = MetricsTransmitter.launch();
        AgentRunner.startOnThread((AgentRunner)new AgentRunner((IdleStrategy)new BackoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)new MetricsReaderAgent("MetricsReaderAgent", metricsTransmitter.context().broadcastBuffer(), (EpochClock)SystemEpochClock.INSTANCE, Duration.ofSeconds(3L), (MetricsHandler)new MimirHistogramHandler(pushUrl))));
        long highestTrackableValue = 1000000000L;
        double conversionFactor = 0.001;
        int resolutionMs = 3000;
        HistogramMetric latencyMetric = metricsRecorder.newHistogram(keyFlyweight -> keyFlyweight.tagsCount(1).stringValue("name", "hft_latency"), 1000000000L, 0.001, 3000L);
        while (true) {
            long now = System.nanoTime();
            MimirAllInOneHistogram.burnCpuMicros(20L);
            latencyMetric.record(System.nanoTime() - now);
            Thread.onSpinWait();
        }
    }

    private static void burnCpuMicros(long micros) {
        long durationNanos = micros * 1000L;
        long start = System.nanoTime();
        while (System.nanoTime() - start < durationNanos) {
            Thread.onSpinWait();
        }
    }

    private static class MimirHistogramHandler
    implements MetricsHandler {
        private final String pushUrl;
        private final HttpClient httpClient = HttpClient.newHttpClient();
        private final KeyCodec keyCodec = new KeyCodec();

        private MimirHistogramHandler(String pushUrl) {
            this.pushUrl = pushUrl;
        }

        public void onHistogram(long timestamp, DirectBuffer keyBuffer, int keyOffset, int keyLength, Histogram accumulated, Histogram distinct, long highestTrackableValue, double conversionFactor) {
            Key key = this.keyCodec.decodeKey(keyBuffer, keyOffset);
            String name = key.stringValue("name");
            Types.Histogram histogram = MimirHistogramHandler.buildPromNativeHistogram(accumulated, 8, timestamp);
            Types.TimeSeries timeSeries = MimirHistogramHandler.wrapIntoTimeSeries(name, histogram);
            try {
                this.push(timeSeries);
                System.out.println(String.valueOf(Instant.now()) + " | push(timeSeries)");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static List<Double> computePromNativeBucketBoundaries(double minNs, double maxNs, int schema) {
            double min = minNs / 1000.0;
            double max = maxNs / 1000.0;
            double factor = Math.pow(2.0, Math.pow(2.0, -schema));
            ArrayList<Double> boundaries = new ArrayList<Double>();
            for (double current = min; current < max; current *= factor) {
                boundaries.add(current);
            }
            return boundaries;
        }

        private static List<Long> convertHdrToPromBuckets(Histogram hdr, List<Double> boundaries) {
            ArrayList<Long> bucketCounts = new ArrayList<Long>(boundaries.size());
            long cumulative = 0L;
            for (double boundaryUs : boundaries) {
                long boundaryNs = (long)Math.ceil(boundaryUs * 1000.0);
                long count = hdr.getCountBetweenValues(0L, boundaryNs);
                bucketCounts.add(count - cumulative);
                cumulative = count;
            }
            return bucketCounts;
        }

        private static Types.Histogram buildPromNativeHistogram(Histogram hdr, int schema, long timestamp) {
            double minNs = hdr.getMinNonZeroValue();
            double maxNs = hdr.getMaxValue();
            List<Double> boundaries = MimirHistogramHandler.computePromNativeBucketBoundaries(minNs, maxNs, schema);
            List<Long> bucketCounts = MimirHistogramHandler.convertHdrToPromBuckets(hdr, boundaries);
            double totalSumNs = 0.0;
            for (HistogramIterationValue value : hdr.recordedValues()) {
                totalSumNs += (double)(value.getValueIteratedTo() * value.getCountAtValueIteratedTo());
            }
            double totalSumUs = totalSumNs / 1000.0;
            Types.Histogram.Builder builder = Types.Histogram.newBuilder().setSchema(schema).setCountInt(hdr.getTotalCount()).setZeroCountInt(0L).setSum(totalSumUs).setTimestamp(timestamp);
            ArrayList<Long> deltas = new ArrayList<Long>();
            ArrayList<Types.BucketSpan> spans = new ArrayList<Types.BucketSpan>();
            int baseBucket = 0;
            int spanStart = -1;
            int spanLength = 0;
            boolean inSpan = false;
            for (int i = 0; i < bucketCounts.size(); ++i) {
                long count = bucketCounts.get(i);
                if (count > 0L) {
                    if (!inSpan) {
                        spanStart = i;
                        spanLength = 1;
                        inSpan = true;
                    } else {
                        ++spanLength;
                    }
                    deltas.add(count);
                    continue;
                }
                if (!inSpan) continue;
                spans.add(Types.BucketSpan.newBuilder().setOffset(spanStart - baseBucket).setLength(spanLength).build());
                baseBucket = spanStart + spanLength;
                inSpan = false;
            }
            if (inSpan) {
                spans.add(Types.BucketSpan.newBuilder().setOffset(spanStart - baseBucket).setLength(spanLength).build());
            }
            builder.addAllPositiveSpans(spans);
            builder.addAllPositiveDeltas(deltas);
            return builder.build();
        }

        private static Types.TimeSeries wrapIntoTimeSeries(String name, Types.Histogram histogram) {
            Types.TimeSeries.Builder builder = Types.TimeSeries.newBuilder();
            builder.addLabels(Types.Label.newBuilder().setName("__name__").setValue(name));
            builder.addLabels(Types.Label.newBuilder().setName("service").setValue("hft_app"));
            builder.addHistograms(histogram);
            return builder.build();
        }

        private void push(Types.TimeSeries timeSeries) throws Exception {
            byte[] payload = Remote.WriteRequest.newBuilder().addTimeseries(timeSeries).build().toByteArray();
            byte[] compressedPayload = Snappy.compress((byte[])payload);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.pushUrl)).header("Content-Type", "application/x-protobuf").header("Content-Encoding", "snappy").header("X-Prometheus-Remote-Write-Version", "0.1.0").POST(HttpRequest.BodyPublishers.ofByteArray(compressedPayload)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                System.err.println("Failed to push metrics: HTTP " + response.statusCode() + ", body: " + response.body());
            }
        }
    }
}

