/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples.services.stocks;

import io.scalecube.examples.services.stocks.Quote;
import io.scalecube.examples.services.stocks.QuotesStreamProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;

public class RandomQuoteGenerator
implements QuotesStreamProvider {
    private final ScheduledExecutorService quoutGenerator = Executors.newScheduledThreadPool(1);
    private final Subject<Quote, Quote> quotes = ReplaySubject.create();
    private final ConcurrentMap<String, Quote> qoutesData = new ConcurrentHashMap<String, Quote>();

    public RandomQuoteGenerator() {
        this.qoutesData.putIfAbsent("AXP", Quote.create("NASDC", "AXP", Float.valueOf(17.5f)));
        this.qoutesData.putIfAbsent("AAPL", Quote.create("NASDC", "AAPL", Float.valueOf(18.3f)));
        this.qoutesData.putIfAbsent("ORCL", Quote.create("NYCE", "ORCL", Float.valueOf(13.1f)));
        this.start();
    }

    @Override
    public Subject<Quote, Quote> subject() {
        return this.quotes;
    }

    private void start() {
        this.quoutGenerator.scheduleWithFixedDelay(() -> this.qoutesData.forEach((symbol, quote) -> {
            this.quotes.onNext(quote);
            double price = this.generateRandom();
            this.qoutesData.put((String)symbol, quote.update(price));
        }), 1L, 1L, TimeUnit.SECONDS);
    }

    private double generateRandom() {
        return Math.random() * 100.0 / 1000.0 + 1.0;
    }
}

