/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import com.google.common.collect.ImmutableMap;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.Member;
import io.scalecube.transport.Address;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterJoinExamples {
    public static void main(String[] args) throws Exception {
        Cluster alice = Cluster.joinAwait();
        Cluster bob = Cluster.joinAwait((Address[])new Address[]{alice.address()});
        ImmutableMap metadata = ImmutableMap.of((Object)"name", (Object)"Carol");
        Cluster carol = Cluster.joinAwait((Map)metadata, (Address[])new Address[]{alice.address()});
        ClusterConfig configWithFixedPort = ClusterConfig.builder().seedMembers(new Address[]{alice.address()}).portAutoIncrement(false).port(3000).build();
        Cluster dan = Cluster.joinAwait((ClusterConfig)configWithFixedPort);
        ClusterConfig configWithSyncGroup = ClusterConfig.builder().seedMembers(new Address[]{alice.address(), bob.address(), carol.address(), dan.address()}).syncGroup("another cluster").build();
        Cluster eve = Cluster.joinAwait((ClusterConfig)configWithSyncGroup);
        System.out.println("Alice (" + alice.address() + ") cluster: " + alice.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Bob (" + bob.address() + ") cluster: " + bob.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Carol (" + carol.address() + ") cluster: " + carol.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Dan (" + dan.address() + ") cluster: " + dan.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Eve (" + eve.address() + ") cluster: " + eve.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
    }
}

