/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import com.google.common.collect.ImmutableMap;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ICluster;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipConfig;
import io.scalecube.transport.Address;
import io.scalecube.transport.TransportConfig;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterJoinExamples {
    public static void main(String[] args) throws Exception {
        ICluster alice = Cluster.joinAwait();
        ICluster bob = Cluster.joinAwait((Address[])new Address[]{alice.address()});
        ImmutableMap metadata = ImmutableMap.of((Object)"name", (Object)"Carol");
        ICluster carol = Cluster.joinAwait((Map)metadata, (Address[])new Address[]{alice.address()});
        ClusterConfig configWithFixedPort = ClusterConfig.builder().membershipConfig(MembershipConfig.builder().seedMembers(new Address[]{alice.address()}).build()).transportConfig(TransportConfig.builder().portAutoIncrement(false).port(3000).build()).build();
        ICluster dan = Cluster.joinAwait((ClusterConfig)configWithFixedPort);
        ClusterConfig configWithSyncGroup = ClusterConfig.builder().membershipConfig(MembershipConfig.builder().seedMembers(new Address[]{alice.address(), bob.address(), carol.address(), dan.address()}).syncGroup("another cluster").build()).build();
        ICluster eve = Cluster.joinAwait((ClusterConfig)configWithSyncGroup);
        System.out.println("Alice (" + alice.address() + ") cluster: " + alice.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Bob (" + bob.address() + ") cluster: " + bob.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Carol (" + carol.address() + ") cluster: " + carol.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Dan (" + dan.address() + ") cluster: " + dan.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
        System.out.println("Eve (" + eve.address() + ") cluster: " + eve.members().stream().map(Member::toString).collect(Collectors.joining("\n", "\n", "\n")));
    }
}

