/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ICluster;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;

public class MessagingExample {
    public static void main(String[] args) throws Exception {
        ICluster alice = Cluster.joinAwait();
        alice.listen().subscribe(msg -> {
            System.out.println("Alice received: " + msg.data());
            alice.send(msg.sender(), Message.fromData((Object)"Greetings from Alice"));
        });
        ICluster bob = Cluster.joinAwait((Address[])new Address[]{alice.address()});
        bob.listen().subscribe(msg -> {
            System.out.println("Bob received: " + msg.data());
            bob.send(msg.sender(), Message.fromData((Object)"Greetings from Bob"));
        });
        ICluster carol = Cluster.joinAwait((Address[])new Address[]{alice.address(), bob.address()});
        carol.listen().map(msg -> "Carol received: " + msg.data()).subscribe(System.out::println);
        Message greetingMsg = Message.fromData((Object)"Greetings from Carol");
        carol.otherMembers().forEach(member -> carol.send(member, greetingMsg));
        Thread.sleep(1000L);
    }
}

