/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import com.google.common.collect.ImmutableMap;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ICluster;
import io.scalecube.cluster.Member;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ClusterMetadataExample {
    public static void main(String[] args) throws Exception {
        ICluster alice = Cluster.joinAwait();
        ImmutableMap metadata = ImmutableMap.of((Object)"name", (Object)"Joe");
        ICluster joe = Cluster.joinAwait((Map)metadata, (Address[])new Address[]{alice.address()});
        joe.listen().map(Message::data).subscribe(System.out::println);
        Optional<Member> joeMemberOptional = alice.otherMembers().stream().filter(member -> "Joe".equals(member.metadata().get("name"))).findAny();
        if (joeMemberOptional.isPresent()) {
            alice.send(joeMemberOptional.get(), Message.fromData((Object)"Hello Joe"));
        }
        TimeUnit.SECONDS.sleep(3L);
    }
}

