/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.LoggingConfigEventListener;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.FileDirectoryConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;

public class DemoConfig {
    public static void main(String[] args) {
        String databaseName = "MongoConfigExample";
        String uri = "mongodb://localhost:27017/" + databaseName;
        String configSourceCollectionName = "MongoConfigRepository";
        String auditLogCollectionName = "TestConfigurationAuditLog";
        Predicate<Path> propsPredicate = path -> path.toString().endsWith(".props");
        String basePath = "config-examples/config";
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("ConfigDirectory", (ConfigSource)new FileDirectoryConfigSource(basePath, propsPredicate)).addListener((ConfigEventListener)new LoggingConfigEventListener()).keepRecentConfigEvents(10).reloadIntervalSec(3).jmxEnabled(true).jmxMBeanName("config.exporter:name=ConfigRegistry").build());
        SomeComponent component = new SomeComponent(configRegistry);
    }

    static class SomeComponent {
        private StringConfigProperty host;

        SomeComponent(ConfigRegistry cfgReg) {
            this.host = cfgReg.stringProperty("host");
            this.host.addCallback((oldVal, newVal) -> System.out.println("###Property changed: " + oldVal + "->" + newVal));
        }
    }
}

