/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.source.ClassPathConfigSource;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.FileDirectoryConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;

public class LocalResourceConfigExample {
    public static void main(String[] args) {
        Predicate<Path> propsPredicate = path -> path.toString().endsWith(".props");
        String basePath = "config-examples/config";
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("classpath", (ConfigSource)new ClassPathConfigSource(propsPredicate)).addLastSource("configDirectory", (ConfigSource)new FileDirectoryConfigSource(basePath, propsPredicate)).jmxEnabled(false).build());
        StringConfigProperty prop1 = configRegistry.stringProperty("prop1");
        StringConfigProperty prop2 = configRegistry.stringProperty("prop2");
        System.out.println("### Classpath property: prop1=" + (String)prop1.value().get());
        System.out.println("### Property existing only in filesystem: prop2=" + (String)prop2.value().get());
    }
}

