/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.Slf4JConfigEventListener;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.SystemPropertiesConfigSource;
import io.scalecube.config.utils.ThrowableUtil;
import java.util.function.Function;

public class JsonObjectExample {
    private static final int RELOAD_INTERVAL_SEC = 3;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void main(String[] args) {
        System.setProperty("jsonKey", "{\"name\":\"property\",\"value\":1322134}");
        ConfigRegistrySettings configRegistrySettings = ConfigRegistrySettings.builder().reloadIntervalSec(3).jmxEnabled(false).addListener((ConfigEventListener)new Slf4JConfigEventListener()).addLastSource("systemProperties", (ConfigSource)new SystemPropertiesConfigSource()).build();
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)configRegistrySettings);
        JsonEntity entity = (JsonEntity)configRegistry.objectProperty("jsonKey", JsonObjectExample.mapper(JsonEntity.class)).value(null);
        System.out.println("entity = " + entity);
    }

    private static <T> Function<String, T> mapper(Class<T> clazz) {
        return value -> {
            try {
                return objectMapper.readValue(value, clazz);
            }
            catch (Exception e) {
                throw ThrowableUtil.propagate((Throwable)e);
            }
        };
    }

    static class JsonEntity {
        private String name;
        private Integer value;

        JsonEntity() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }
}

