/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.audit.Slf4JConfigEventListener;
import io.scalecube.config.http.server.ConfigRegistryHttpServer;
import io.scalecube.config.source.ClassPathConfigSource;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.FileDirectoryConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;

public class ConfigRegistryExample {
    public static void main(String[] args) {
        Predicate<Path> propsPredicate = path -> path.toString().endsWith(".props");
        String basePath = "config-examples/config";
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("classpath", (ConfigSource)new ClassPathConfigSource(propsPredicate)).addLastSource("configDirectory", (ConfigSource)new FileDirectoryConfigSource(basePath, propsPredicate)).addListener((ConfigEventListener)new Slf4JConfigEventListener()).jmxEnabled(true).jmxMBeanName("config.exporter:name=ConfigRegistry").build());
        StringConfigProperty orderedProp1 = configRegistry.stringProperty("orderedProp1");
        System.out.println("### Matched by first predicate orderedProp1=" + (String)orderedProp1.value().get());
        ConfigRegistryHttpServer.create((ConfigRegistry)configRegistry, (int)5050);
    }
}

