/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron.server;

import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.aeron.AeronEventLoop;
import reactor.aeron.AeronOptions;
import reactor.aeron.AeronResources;
import reactor.aeron.Connection;
import reactor.aeron.OnDisposable;
import reactor.aeron.server.AeronServerHandler;
import reactor.aeron.server.AeronServerSettings;
import reactor.core.publisher.Mono;

public final class AeronServer {
    private static final int CONTROL_STREAM_ID = 1;
    private final AeronServerSettings settings;

    private AeronServer(AeronServerSettings settings) {
        this.settings = settings;
    }

    public static AeronServer create(AeronResources aeronResources) {
        return AeronServer.create("server", aeronResources);
    }

    public static AeronServer create(String name, AeronResources aeronResources) {
        return new AeronServer(AeronServerSettings.builder().name(name).aeronResources(aeronResources).build());
    }

    public Mono<? extends OnDisposable> bind() {
        return this.bind(this.settings.options());
    }

    public Mono<? extends OnDisposable> bind(AeronOptions options) {
        return Mono.defer(() -> {
            AeronServerSettings settings = this.settings.options(options);
            AeronServerHandler serverHandler = new AeronServerHandler(settings);
            AeronResources resources = settings.aeronResources();
            String category = settings.name();
            String serverChannel = settings.options().serverChannel();
            AeronEventLoop eventLoop = resources.nextEventLoop();
            return resources.controlSubscription(category, serverChannel, 1, serverHandler, eventLoop, null, null).map(controlSubscription -> {
                serverHandler.onSubscription((Subscription)controlSubscription);
                serverHandler.onDispose().doFinally(s -> controlSubscription.dispose()).subscribe(null, ex -> {});
                return serverHandler;
            });
        });
    }

    public AeronServer options(Consumer<AeronOptions.Builder> options) {
        return new AeronServer(this.settings.options(options));
    }

    public AeronServer handle(Function<? super Connection, ? extends Publisher<Void>> handler) {
        return new AeronServer(this.settings.handler(handler));
    }
}

