/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import reactor.aeron.MessageType;

public class Protocol {
    private static final int SIZE_OF_UUID = 16;
    public static final int HEADER_SIZE = 9;

    static int putHeader(MutableDirectBuffer buffer, int index, MessageType requestType, long sessionId) {
        buffer.putByte(index, (byte)requestType.ordinal());
        buffer.putLong(++index, sessionId);
        return index += 8;
    }

    private static int putUuid(MutableDirectBuffer buffer, int index, UUID sessionId) {
        buffer.putLong(index, sessionId.getMostSignificantBits());
        buffer.putLong(index += 8, sessionId.getLeastSignificantBits());
        return index += 8;
    }

    public static ByteBuffer createConnectBody(UUID connectRequestId, String clientChannel, int clientControlStreamId, int clientSessionStreamId) {
        byte[] clientChannelBytes = clientChannel.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[clientChannelBytes.length + 12 + 16];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        int index = 0;
        index += Protocol.putUuid((MutableDirectBuffer)buffer, index, connectRequestId);
        buffer.putInt(index, clientChannelBytes.length);
        buffer.putBytes(index += 4, clientChannelBytes);
        buffer.putInt(index += clientChannelBytes.length, clientControlStreamId);
        buffer.putInt(index += 4, clientSessionStreamId);
        return ByteBuffer.wrap(bytes, 0, index += 4);
    }

    public static ByteBuffer createConnectAckBody(UUID connectRequestId, int serverSessionStreamId) {
        byte[] array = new byte[20];
        UnsafeBuffer buffer = new UnsafeBuffer(array);
        int index = 0;
        buffer.putInt(index, serverSessionStreamId);
        Protocol.putUuid((MutableDirectBuffer)buffer, index += 4, connectRequestId);
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer createDisconnectBody(long sessionId) {
        byte[] bytes = new byte[8];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        buffer.putLong(0, sessionId);
        return ByteBuffer.wrap(bytes);
    }
}

