/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import reactor.aeron.AeronEventLoop;
import reactor.aeron.OnDisposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.Operators;

public final class InnerPoller
implements org.reactivestreams.Subscription,
OnDisposable,
AutoCloseable {
    private static final AtomicLongFieldUpdater<InnerPoller> REQUESTED = AtomicLongFieldUpdater.newUpdater(InnerPoller.class, "requested");
    private final AeronEventLoop eventLoop;
    private final Subscription subscription;
    private final FragmentHandler fragmentHandler;
    private final MonoProcessor<Void> onDispose = MonoProcessor.create();
    private volatile long requested = 0L;

    public InnerPoller(AeronEventLoop eventLoop, Subscription subscription, FragmentHandler fragmentHandler) {
        this.eventLoop = eventLoop;
        this.subscription = subscription;
        this.fragmentHandler = fragmentHandler;
    }

    public int poll() {
        int r = (int)Math.min(this.requested, 8L);
        int numOfPolled = 0;
        if (r > 0 && (numOfPolled = this.subscription.poll(this.fragmentHandler, r)) > 0) {
            Operators.produced(REQUESTED, (Object)this, (long)numOfPolled);
        }
        return numOfPolled;
    }

    public void request(long n) {
        Operators.addCap(REQUESTED, (Object)this, (long)n);
    }

    public void cancel() {
    }

    @Override
    public void close() {
        if (!this.eventLoop.inEventLoop()) {
            throw new IllegalStateException("Can only close aeron subscription from within event loop");
        }
        try {
            this.subscription.close();
        }
        finally {
            this.onDispose.onComplete();
        }
    }

    public void dispose() {
        this.eventLoop.dispose(this).subscribe(null, th -> {});
    }

    public boolean isDisposed() {
        return this.subscription.isClosed();
    }

    @Override
    public Mono<Void> onDispose() {
        return this.onDispose;
    }
}

