/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import reactor.aeron.DataMessageSubscriber;
import reactor.aeron.MessageType;
import reactor.util.Logger;
import reactor.util.Loggers;

public class DataFragmentHandler
implements FragmentHandler {
    private final Logger logger = Loggers.getLogger(DataFragmentHandler.class);
    private final DataMessageSubscriber subscriber;

    public DataFragmentHandler(DataMessageSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int index = offset;
        byte type = buffer.getByte(index);
        long sessionId = buffer.getLong(++index);
        index += 8;
        if (type == MessageType.NEXT.ordinal()) {
            int bytesLength = length - (index - offset);
            ByteBuffer dst = ByteBuffer.allocate(bytesLength);
            buffer.getBytes(index, dst, bytesLength);
            dst.rewind();
            this.subscriber.onNext(sessionId, dst);
        } else {
            this.logger.error("Unknown message type id: {}", new Object[]{(int)type});
            this.subscriber.onComplete(sessionId);
        }
    }
}

