/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.UUID;
import org.agrona.DirectBuffer;
import reactor.aeron.ControlMessageSubscriber;
import reactor.aeron.MessageType;
import reactor.util.Logger;
import reactor.util.Loggers;

public class ControlFragmentHandler
implements FragmentHandler {
    private final Logger logger = Loggers.getLogger(ControlFragmentHandler.class);
    private final ControlMessageSubscriber subscriber;

    public ControlFragmentHandler(ControlMessageSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int index = offset;
        byte type = buffer.getByte(index);
        long sessionId = buffer.getLong(++index);
        index += 8;
        if (type == MessageType.CONNECT.ordinal()) {
            long mostSigBits = buffer.getLong(index);
            long leastSigBits = buffer.getLong(index += 8);
            UUID connectRequestId = new UUID(mostSigBits, leastSigBits);
            int channelLength = buffer.getInt(index += 8);
            String channel = buffer.getStringUtf8(index, channelLength);
            int clientControlStreamId = buffer.getInt(index += 4 + channelLength);
            int clientSessionStreamId = buffer.getInt(index += 4);
            this.subscriber.onConnect(connectRequestId, channel, clientControlStreamId, clientSessionStreamId);
        } else if (type == MessageType.CONNECT_ACK.ordinal()) {
            int serverSessionStreamId = buffer.getInt(index);
            long mostSigBits = buffer.getLong(index += 4);
            long leastSigBits = buffer.getLong(index += 8);
            UUID connectRequestId = new UUID(mostSigBits, leastSigBits);
            this.subscriber.onConnectAck(connectRequestId, sessionId, serverSessionStreamId);
        } else if (type == MessageType.COMPLETE.ordinal()) {
            this.subscriber.onComplete(sessionId);
        } else {
            this.logger.error("Unknown message type id: {}", new Object[]{(int)type});
            this.subscriber.onComplete(sessionId);
        }
    }
}

