/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import org.reactivestreams.Subscription;
import reactor.aeron.AeronInbound;
import reactor.aeron.AeronOutbound;
import reactor.aeron.OnDisposable;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.SignalType;

public interface Connection
extends OnDisposable {
    default public <T extends Connection> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            Connection thiz = this;
            return (T)thiz;
        }
        return null;
    }

    public AeronInbound inbound();

    public AeronOutbound outbound();

    default public Connection onDispose(Disposable onDispose) {
        this.onDispose().doOnTerminate(() -> ((Disposable)onDispose).dispose()).subscribe();
        return this;
    }

    default public CoreSubscriber<Void> disposeSubscriber() {
        return new BaseSubscriber<Void>(){

            protected void hookOnSubscribe(Subscription subscription) {
                this.request(Long.MAX_VALUE);
                Connection.this.onDispose().subscribe(null, e -> this.dispose(), () -> (this).dispose());
            }

            protected void hookFinally(SignalType type) {
                if (type != SignalType.CANCEL) {
                    this.dispose();
                }
            }
        };
    }
}

