/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.Publication;
import io.aeron.Subscription;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class AeronUtils {
    public static final String CHANNEL_PREFIX = "aeron:udp?endpoint=";

    public static String format(Publication publication) {
        return AeronUtils.format(publication.channel(), publication.streamId());
    }

    public static String format(Subscription subscription) {
        return AeronUtils.format(subscription.channel(), subscription.streamId());
    }

    public static String format(String channel, int streamId) {
        return '(' + AeronUtils.minifyChannel(channel) + ", streamId: " + streamId + ')';
    }

    public static String minifyChannel(String channel) {
        if (channel.startsWith(CHANNEL_PREFIX)) {
            channel = channel.substring(CHANNEL_PREFIX.length());
        }
        return channel;
    }

    public static String byteBufferToString(ByteBuffer buffer) {
        return new String(buffer.array(), buffer.position(), buffer.limit());
    }

    public static ByteBuffer stringToByteBuffer(String str) {
        return ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8));
    }
}

