/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.driver.Configuration;
import io.aeron.driver.ThreadingMode;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;

public class AeronResourcesConfig {
    private final ThreadingMode threadingMode;
    private final boolean dirDeleteOnStart;
    private final int mtuLength;
    private final Duration imageLivenessTimeout;
    private final Supplier<IdleStrategy> idleStrategySupplier;

    private AeronResourcesConfig(Builder builder) {
        this.threadingMode = builder.threadingMode;
        this.dirDeleteOnStart = builder.dirDeleteOnStart;
        this.mtuLength = builder.mtuLength;
        this.imageLivenessTimeout = builder.imageLivenessTimeout;
        this.idleStrategySupplier = builder.idleStrategySupplier;
    }

    private static BackoffIdleStrategy defaultBackoffIdleStrategy() {
        return new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
    }

    public static AeronResourcesConfig defaultConfig() {
        return AeronResourcesConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isDirDeleteOnStart() {
        return this.dirDeleteOnStart;
    }

    public ThreadingMode threadingMode() {
        return this.threadingMode;
    }

    public int mtuLength() {
        return this.mtuLength;
    }

    public Duration imageLivenessTimeout() {
        return this.imageLivenessTimeout;
    }

    public Supplier<IdleStrategy> idleStrategySupplier() {
        return this.idleStrategySupplier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AeronResourcesConfig{");
        sb.append(", threadingMode=").append(this.threadingMode);
        sb.append(", dirDeleteOnStart=").append(this.dirDeleteOnStart);
        sb.append(", mtuLength=").append(this.mtuLength);
        sb.append(", imageLivenessTimeout=").append(this.imageLivenessTimeout);
        sb.append(", idleStrategySupplier=").append(this.idleStrategySupplier);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private ThreadingMode threadingMode = ThreadingMode.DEDICATED;
        private boolean dirDeleteOnStart = true;
        private int mtuLength = Configuration.MTU_LENGTH;
        private Duration imageLivenessTimeout = Duration.ofNanos(Configuration.IMAGE_LIVENESS_TIMEOUT_NS);
        private Supplier<IdleStrategy> idleStrategySupplier = () -> AeronResourcesConfig.access$700();

        private Builder() {
        }

        public Builder useThreadModeInvoker() {
            this.threadingMode = ThreadingMode.INVOKER;
            return this;
        }

        public Builder useThreadModeShared() {
            this.threadingMode = ThreadingMode.SHARED;
            return this;
        }

        public Builder useThreadModeSharedNetwork() {
            this.threadingMode = ThreadingMode.SHARED_NETWORK;
            return this;
        }

        public Builder useThreadModeDedicated() {
            this.threadingMode = ThreadingMode.DEDICATED;
            return this;
        }

        public Builder dirDeleteOnStart(boolean dirDeleteOnStart) {
            this.dirDeleteOnStart = dirDeleteOnStart;
            return this;
        }

        public Builder mtuLength(int mtuLength) {
            this.mtuLength = mtuLength;
            return this;
        }

        public Builder imageLivenessTimeout(Duration imageLivenessTimeout) {
            this.imageLivenessTimeout = imageLivenessTimeout;
            return this;
        }

        public Builder idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public AeronResourcesConfig build() {
            return new AeronResourcesConfig(this);
        }
    }
}

