/*
 * Decompiled with CFR 0.152.
 */
package reactor.aeron;

import io.aeron.ChannelUriStringBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;

public final class AeronOptions {
    public static final Duration ACK_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    public static final Duration BACKPRESSURE_TIMEOUT = Duration.ofSeconds(5L);
    private final ChannelUriStringBuilder serverChannel;
    private final ChannelUriStringBuilder clientChannel;
    private final Duration ackTimeout;
    private final Duration connectTimeout;
    private final Duration backpressureTimeout;

    private AeronOptions(Builder builder) {
        this.serverChannel = builder.serverChannel.validate();
        this.clientChannel = builder.clientChannel.validate();
        this.ackTimeout = this.validate(builder.ackTimeout, "ackTimeout");
        this.connectTimeout = this.validate(builder.connectTimeout, "connectTimeout");
        this.backpressureTimeout = this.validate(builder.backpressureTimeout, "backpressureTimeout");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String serverChannel() {
        return this.serverChannel.build();
    }

    public String clientChannel() {
        return this.clientChannel.build();
    }

    public Duration ackTimeout() {
        return this.ackTimeout;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public Duration backpressureTimeout() {
        return this.backpressureTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AeronOptions{");
        sb.append("serverChannel=").append(this.serverChannel);
        sb.append(", clientChannel=").append(this.clientChannel);
        sb.append(", ackTimeout=").append(this.ackTimeout);
        sb.append(", connectTimeout=").append(this.connectTimeout);
        sb.append(", backpressureTimeout=").append(this.backpressureTimeout);
        sb.append('}');
        return sb.toString();
    }

    private Duration validate(Duration value, String message) {
        Objects.requireNonNull(value, message);
        if (value.compareTo(Duration.ZERO) <= 0) {
            throw new IllegalArgumentException(message + " > 0 expected, but got: " + value);
        }
        return value;
    }

    private int validate(Integer value, String message) {
        Objects.requireNonNull(value, message);
        if (value <= 0) {
            throw new IllegalArgumentException(message + " > 0 expected, but got: " + value);
        }
        return value;
    }

    public static class Builder {
        private ChannelUriStringBuilder serverChannel = this.serverChannelBuilder();
        private ChannelUriStringBuilder clientChannel = this.clientChannelBuilder();
        private Duration ackTimeout = ACK_TIMEOUT;
        private Duration connectTimeout = CONNECT_TIMEOUT;
        private Duration backpressureTimeout = BACKPRESSURE_TIMEOUT;

        private Builder() {
        }

        public Builder serverChannel(ChannelUriStringBuilder serverChannel) {
            this.serverChannel = serverChannel;
            return this;
        }

        public Builder serverChannel(Consumer<ChannelUriStringBuilder> consumer) {
            ChannelUriStringBuilder channelBuilder = this.serverChannelBuilder();
            consumer.accept(channelBuilder);
            this.serverChannel = channelBuilder;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder backpressureTimeout(Duration backpressureTimeout) {
            this.backpressureTimeout = backpressureTimeout;
            return this;
        }

        public Builder clientChannel(ChannelUriStringBuilder clientChannel) {
            this.clientChannel = clientChannel;
            return this;
        }

        public Builder clientChannel(Consumer<ChannelUriStringBuilder> consumer) {
            ChannelUriStringBuilder builder = this.clientChannelBuilder();
            consumer.accept(builder);
            this.clientChannel = builder;
            return this;
        }

        public Builder ackTimeout(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        private ChannelUriStringBuilder serverChannelBuilder() {
            return new ChannelUriStringBuilder().reliable(Boolean.valueOf(true)).media("udp");
        }

        private ChannelUriStringBuilder clientChannelBuilder() {
            return new ChannelUriStringBuilder().reliable(Boolean.valueOf(true)).media("udp").endpoint("localhost:0");
        }

        public AeronOptions build() {
            return new AeronOptions(this);
        }
    }
}

