/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.websocket;

import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.examples.ExamplesEnvironment;
import io.reactivex.netty.protocol.http.websocket.WebSocketClient;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class WebSocketHelloClient
extends ExamplesEnvironment {
    static final int DEFAULT_NO_OF_EVENTS = 100;
    static final int DEFAULT_INTERVAL = 100;
    private final int port;

    public WebSocketHelloClient(int port) {
        this.port = port;
    }

    public void sendHelloRequests(int noOfEvents, int interval) throws Exception {
        WebSocketClient rxClient = (WebSocketClient)RxNetty.newWebSocketClientBuilder((String)"localhost", (int)this.port).withWebSocketURI("/websocket").withWebSocketVersion(WebSocketVersion.V13).build();
        rxClient.connect().flatMap(connection -> connection.writeAndFlush((Object)new TextWebSocketFrame("ping")).concatWith(connection.getInput().take(noOfEvents).flatMap(webSocketFrame -> {
            System.out.println("Got back: " + webSocketFrame.text());
            return Observable.timer((long)interval, (TimeUnit)TimeUnit.MILLISECONDS).flatMap(aLong -> connection.writeAndFlush((Object)new TextWebSocketFrame("ping")));
        }))).toBlocking().last();
    }

    public static void main(String[] args) throws Exception {
        int port = 8090;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        new WebSocketHelloClient(port).sendHelloRequests(100, 100);
    }
}

