/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.chunk;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.HttpServer;
import java.io.FileReader;
import java.io.Reader;
import rx.observables.StringObservable;

public class HttpChunkServer {
    static final int DEFAULT_PORT = 8103;
    private final int port;
    private final String textFile;

    public HttpChunkServer(int port, String textFile) {
        this.port = port;
        this.textFile = textFile;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        return RxNetty.createHttpServer((int)this.port, (request, response) -> StringObservable.using(() -> new FileReader(this.textFile), reader -> StringObservable.from((Reader)reader)).flatMap(text -> response.writeStringAndFlush(text)));
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("ERROR: give text file name");
            return;
        }
        String textFile = args[0];
        System.out.println("HTTP chunk server starting on port 8103 ...");
        new HttpChunkServer(8103, textFile).createServer().startAndWait();
    }
}

